/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.spells.entities.single_target_bolt;

import com.robertx22.mine_and_slash.database.spells.entities.bases.BaseElementalBoltEntity;
import com.robertx22.mine_and_slash.database.spells.entities.bases.ISpellEntity;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.configs.SC;
import com.robertx22.mine_and_slash.mmorpg.registers.common.EntityRegister;
import com.robertx22.mine_and_slash.uncommon.effectdatas.SpellDamageEffect;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Elements;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.EntityFinder;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.GeometryUtils;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.ParticleUtils;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.SoundUtils;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.FMLPlayMessages;

public class FrozenOrbEntity
extends BaseElementalBoltEntity {
    public FrozenOrbEntity(EntityType<? extends FrozenOrbEntity> type, World world) {
        super(type, world);
    }

    public FrozenOrbEntity(World worldIn) {
        super(EntityRegister.FROZEN_ORB, worldIn);
    }

    public FrozenOrbEntity(FMLPlayMessages.SpawnEntity spawnEntity, World world) {
        super(EntityRegister.FROZEN_ORB, world);
    }

    @Override
    public double radius() {
        return 3.0;
    }

    @Override
    public Elements element() {
        return Elements.Water;
    }

    @Override
    public void onHit(LivingEntity entity) {
        LivingEntity caster;
        if (this.field_70170_p.field_72995_K) {
            Vec3d p = GeometryUtils.getRandomPosInRadiusCircle(this.func_174791_d(), (float)this.radius());
            ParticleUtils.spawn((IParticleData)ParticleTypes.field_197593_D, this.field_70170_p, p);
        }
        if ((caster = this.getCaster()) == null) {
            return;
        }
        List<LivingEntity> entities = EntityFinder.start(caster, LivingEntity.class, this.func_174791_d()).radius((float)this.radius() * 2.0f).build();
        entities.forEach(x -> {
            SpellDamageEffect dmg = this.dealSpellDamageTo((LivingEntity)x, new ISpellEntity.Options().knockbacks(false).activatesEffect(false));
            dmg.Activate();
            x.func_195064_c(new EffectInstance(Effects.field_76421_d, 3, 5));
            SoundUtils.playSound((Entity)this, SoundEvents.field_187797_fA, 1.5f, 1.25f);
        });
    }

    @Override
    public void onTick() {
        int tickRate;
        if (this.field_70170_p.field_72995_K && this.field_70173_aa > 1) {
            Vec3d p;
            int i;
            for (i = 0; i < 2; ++i) {
                p = GeometryUtils.getRandomPosInRadiusCircle(this.func_174791_d(), (float)this.radius());
                ParticleUtils.spawn((IParticleData)ParticleTypes.field_197593_D, this.field_70170_p, p);
            }
            for (i = 0; i < 3; ++i) {
                p = GeometryUtils.getRandomPosInRadiusCircle(this.func_174791_d(), (float)this.radius() / 2.0f);
                ParticleUtils.spawn((IParticleData)ParticleTypes.field_197593_D, this.field_70170_p, p);
            }
            for (i = 0; i < 5; ++i) {
                p = GeometryUtils.getRandomPosInRadiusCircle(this.func_174791_d(), (float)this.radius());
                ParticleUtils.spawn((IParticleData)ParticleTypes.field_197613_f, this.field_70170_p, p);
            }
        }
        if (this.field_70173_aa % (tickRate = this.getSpellData().configs.get(SC.TICK_RATE).intValue()) == 0) {
            if (!this.field_70170_p.field_72995_K) {
                List<LivingEntity> entities = EntityFinder.start(this.getCaster(), LivingEntity.class, this.func_174791_d()).radius(this.radius()).build();
                entities.forEach(x -> {
                    SpellDamageEffect dmg = this.dealSpellDamageTo((LivingEntity)x, new ISpellEntity.Options().activatesEffect(false).knockbacks(false));
                    dmg.Activate();
                    SoundUtils.playSound((Entity)this, SoundEvents.field_187797_fA, 1.0f, 1.0f);
                });
            } else {
                SoundUtils.playSound((Entity)this, SoundEvents.field_187797_fA, 1.0f, 1.0f);
            }
        }
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 3; ++i) {
                Vec3d p = GeometryUtils.getRandomPosInRadiusCircle(this.func_174791_d(), (float)this.radius());
                ParticleUtils.spawn((IParticleData)ParticleTypes.field_197593_D, this.field_70170_p, p);
            }
        }
    }
}

