/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.spells.entities.trident;

import com.robertx22.mine_and_slash.database.spells.entities.bases.ISpellEntity;
import com.robertx22.mine_and_slash.mmorpg.registers.common.ParticleRegister;
import com.robertx22.mine_and_slash.saveclasses.EntitySpellData;
import com.robertx22.mine_and_slash.uncommon.datasaving.EntitySpellDataSaving;
import com.robertx22.mine_and_slash.uncommon.effectdatas.SpellDamageEffect;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.GeometryUtils;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.ParticleUtils;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.TridentEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public abstract class BaseTridentEntity
extends TridentEntity
implements ISpellEntity {
    EntitySpellData syncedSpellData;

    public BaseTridentEntity(EntityType<? extends TridentEntity> type, World world) {
        super(type, world);
    }

    public void func_70037_a(CompoundNBT nbt) {
        this.syncedSpellData = EntitySpellDataSaving.Load(nbt);
    }

    public void func_213281_b(CompoundNBT nbt) {
        EntitySpellDataSaving.Save(nbt, this.syncedSpellData);
    }

    @Nullable
    public LivingEntity getCaster() {
        return this.getSpellData().getCaster(this.field_70170_p);
    }

    protected void func_70088_a() {
        super.func_70088_a();
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public boolean isValidTarget(Entity target) {
        return true;
    }

    public boolean func_90999_ad() {
        return false;
    }

    public boolean func_96092_aw() {
        return false;
    }

    @Override
    public EntitySpellData getSpellData() {
        return this.syncedSpellData;
    }

    @Override
    public void setSpellData(EntitySpellData data) {
        this.syncedSpellData = data;
    }

    public void writeSpawnData(PacketBuffer buf) {
        CompoundNBT nbt = new CompoundNBT();
        this.func_213281_b(nbt);
        buf.func_150786_a(nbt);
    }

    public void readSpawnData(PacketBuffer buf) {
        CompoundNBT nbt = buf.func_150793_b();
        this.func_70037_a(nbt);
    }

    public void func_70071_h_() {
        if (this.field_184552_b > 50) {
            this.field_70128_L = true;
        }
        if (this.field_70170_p.field_72995_K && this.field_70173_aa > 2) {
            for (int i = 0; i < 10; ++i) {
                Vec3d p = GeometryUtils.getRandomPosInRadiusCircle(this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.1f);
                ParticleUtils.spawn((IParticleData)ParticleRegister.THUNDER, this.field_70170_p, p);
            }
        }
        super.func_70071_h_();
        if (this.field_70128_L) {
            this.func_70106_y();
        }
    }

    public void onHit(LivingEntity en) {
        LivingEntity shooter = this.getCaster();
        SpellDamageEffect dmg = this.dealSpellDamageTo(en, new ISpellEntity.Options().activatesEffect(false));
        dmg.Activate();
    }

    protected void func_213868_a(EntityRayTraceResult ray) {
        Entity entity;
        if (!this.field_70170_p.field_72995_K && (entity = ray.func_216348_a()) instanceof LivingEntity) {
            LivingEntity shooter = this.getCaster();
            if (entity == shooter) {
                return;
            }
            this.func_213317_d(this.func_213322_ci().func_216372_d(-0.01, -0.1, -0.01));
            try {
                this.onHit((LivingEntity)entity);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.func_184185_a(SoundEvents.field_203268_ij, 8.0f, 1.0f);
        }
    }
}

