/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.spells.spell_classes.bases;

import com.robertx22.mine_and_slash.database.gearitemslots.bases.GearItemSlot;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.SpellCastContext;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.configs.ImmutableSpellConfigs;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.configs.SC;
import com.robertx22.mine_and_slash.database.spells.synergies.base.OnSpellCastSynergy;
import com.robertx22.mine_and_slash.database.spells.synergies.base.Synergy;
import com.robertx22.mine_and_slash.database.stats.types.resources.Mana;
import com.robertx22.mine_and_slash.db_lists.Rarities;
import com.robertx22.mine_and_slash.mmorpg.MMORPG;
import com.robertx22.mine_and_slash.packets.NoEnergyPacket;
import com.robertx22.mine_and_slash.registry.ISlashRegistryEntry;
import com.robertx22.mine_and_slash.registry.SlashRegistryType;
import com.robertx22.mine_and_slash.saveclasses.ResourcesData;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.ITooltipList;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.Rarity;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.TooltipInfo;
import com.robertx22.mine_and_slash.saveclasses.spells.IAbility;
import com.robertx22.mine_and_slash.saveclasses.spells.calc.SpellCalcData;
import com.robertx22.mine_and_slash.uncommon.capability.entity.EntityCap;
import com.robertx22.mine_and_slash.uncommon.capability.player.PlayerSpellCap;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Elements;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Masteries;
import com.robertx22.mine_and_slash.uncommon.localization.Words;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.TooltipUtils;
import com.robertx22.mine_and_slash.uncommon.wrappers.SText;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public abstract class BaseSpell
implements ISlashRegistryEntry<BaseSpell>,
ITooltipList,
IAbility {
    private final ImmutableSpellConfigs immutableConfigs;

    public BaseSpell(ImmutableSpellConfigs immutable) {
        this.immutableConfigs = immutable;
    }

    public final ImmutableSpellConfigs getImmutableConfigs() {
        return this.immutableConfigs;
    }

    public final void onCastingTick(SpellCastContext ctx) {
        int timesToCast = (int)ctx.getConfigFor(this).get(SC.TIMES_TO_CAST).get(ctx.spellsCap, (IAbility)this);
        if (timesToCast > 1) {
            int castTimeTicks = (int)ctx.getConfigFor(this).get(SC.CAST_TIME_TICKS).get(ctx.spellsCap, (IAbility)this);
            int castEveryXTicks = castTimeTicks / timesToCast;
            if (ctx.isLastCastTick) {
                this.cast(ctx);
            } else if (ctx.ticksInUse > 0 && ctx.ticksInUse % castEveryXTicks == 0) {
                this.cast(ctx);
            }
        } else if (timesToCast < 1) {
            System.out.println("Times to cast spell is: " + timesToCast + " . this seems like a bug.");
        }
    }

    @Override
    public ITextComponent getLocName() {
        return this.getName().locName();
    }

    public void spawnParticles(SpellCastContext ctx) {
    }

    public final List<Synergy> getAllocatedSynergies(PlayerSpellCap.ISpellsCap cap) {
        return cap.getAbilitiesData().getAllocatedSynergies().stream().filter(x -> x.getRequiredAbility().GUID().equals(this.GUID())).collect(Collectors.toList());
    }

    @Override
    public BaseSpell getSpell() {
        return this;
    }

    @Override
    public final int getMaxSpellLevelNormal() {
        return this.getPreCalcConfig().maxSpellLevel;
    }

    @Override
    public final int getMaxSpellLevelBuffed() {
        return this.getMaxSpellLevelNormal() + 5;
    }

    public boolean shouldActivateCooldown(PlayerEntity player, PlayerSpellCap.ISpellsCap spells) {
        return true;
    }

    @Override
    public IAbility.Type getAbilityType() {
        return IAbility.Type.SPELL;
    }

    @Override
    public IAbility getRequiredAbility() {
        return null;
    }

    public boolean isAllowedAsRightClickFor(GearItemSlot slot) {
        switch (this.immutableConfigs.allowedAsRightClickOn()) {
            case NONE: {
                return false;
            }
            case MELEE_WEAPON: {
                return slot.isMeleeWeapon();
            }
            case MAGE_WEAPON: {
                return slot.isMageWeapon();
            }
        }
        return false;
    }

    @Override
    public int getRarityRank() {
        return 1;
    }

    @Override
    public Rarity getRarity() {
        return Rarities.Gears.get(this.getRarityRank());
    }

    public final boolean goesOnCooldownIfCastCanceled() {
        return this.immutableConfigs.goesOnCooldownIfCanceled();
    }

    @Override
    public final ResourceLocation getIconLoc() {
        return new ResourceLocation("mmorpg", "textures/gui/spells/" + this.getMastery().id + "/" + this.GUID() + ".png");
    }

    @Override
    public final Masteries getMastery() {
        return this.immutableConfigs.school();
    }

    public int getCooldownInTicks(SpellCastContext ctx) {
        int ticks = (int)ctx.getConfigFor(this).get(SC.COOLDOWN_TICKS).get(ctx.spellsCap, (IAbility)this);
        int seconds = (int)ctx.getConfigFor(this).get(SC.COOLDOWN_SECONDS).get(ctx.spellsCap, (IAbility)this);
        return (int)((float)seconds * 20.0f + (float)ticks);
    }

    public final int getCooldownInSeconds(SpellCastContext ctx) {
        return this.getCooldownInTicks(ctx) / 20;
    }

    @Override
    public SlashRegistryType getSlashRegistryType() {
        return SlashRegistryType.SPELL;
    }

    @Override
    public abstract String GUID();

    public final int getCalculatedManaCost(SpellCastContext ctx) {
        return (int)Mana.getInstance().calculateScalingStatGrowth((int)ctx.getConfigFor(this).get(SC.MANA_COST).get(ctx.spellsCap, (IAbility)this), this.getEffectiveAbilityLevel(ctx.spellsCap, ctx.data));
    }

    public final int useTimeTicks(SpellCastContext ctx) {
        return (int)ctx.getConfigFor(this).get(SC.CAST_TIME_TICKS).get(ctx.spellsCap, (IAbility)this);
    }

    public final float getUseDurationInSeconds(SpellCastContext ctx) {
        return (float)this.useTimeTicks(ctx) / 20.0f;
    }

    public final SpellCalcData getCalculation(SpellCastContext ctx) {
        return ctx.getConfigFor(this).getCalc(ctx.spellsCap, this);
    }

    @Override
    public final Elements getElement() {
        return this.immutableConfigs.element();
    }

    public abstract List<ITextComponent> GetDescription(TooltipInfo var1, SpellCastContext var2);

    public abstract Words getName();

    public final boolean cast(SpellCastContext ctx) {
        boolean bool = this.immutableConfigs.castType().cast(ctx);
        this.getAllocatedSynergies(ctx.spellsCap).forEach(x -> {
            if (x instanceof OnSpellCastSynergy) {
                OnSpellCastSynergy s = (OnSpellCastSynergy)x;
                s.tryActivate(ctx);
            }
        });
        ctx.castedThisTick = true;
        if (this.getImmutableConfigs().getSwingsArmOnCast()) {
            ctx.caster.func_226292_a_(Hand.MAIN_HAND, true);
        }
        this.castExtra(ctx);
        return bool;
    }

    public void castExtra(SpellCastContext ctx) {
    }

    public void spendResources(SpellCastContext ctx) {
        ctx.data.getResources().modify(this.getManaCostCtx(ctx));
    }

    public ResourcesData.Context getManaCostCtx(SpellCastContext ctx) {
        float cost = 0.0f;
        for (Synergy x : this.getAllocatedSynergies(ctx.spellsCap)) {
            if (!ctx.getConfigFor(x).has(SC.MANA_COST)) continue;
            cost += ctx.getConfigFor(x).get(SC.MANA_COST).get(ctx.spellsCap, (IAbility)x);
        }
        return new ResourcesData.Context(ctx.data, ctx.caster, ResourcesData.Type.MANA, cost += (float)this.getCalculatedManaCost(ctx), ResourcesData.Use.SPEND);
    }

    public boolean canCast(SpellCastContext ctx) {
        EntityCap.UnitData data;
        LivingEntity caster = ctx.caster;
        if (!(caster instanceof PlayerEntity)) {
            return true;
        }
        PlayerEntity player = (PlayerEntity)caster;
        if (!caster.field_70170_p.field_72995_K && (data = Load.Unit((ICapabilityProvider)caster)) != null) {
            ResourcesData.Context rctx = this.getManaCostCtx(ctx);
            if (data.getResources().hasEnough(rctx)) {
                return !this.immutableConfigs.castRequirements().stream().anyMatch(x -> !x.predicate.test((LivingEntity)player));
            }
            if (caster instanceof ServerPlayerEntity) {
                MMORPG.sendToClient(new NoEnergyPacket(), (ServerPlayerEntity)caster);
            }
        }
        return false;
    }

    @Override
    public final List<ITextComponent> GetTooltipString(TooltipInfo info) {
        SpellCastContext ctx = new SpellCastContext((LivingEntity)info.player, 0, this);
        EntityCap.UnitData data = info.unitdata;
        ArrayList<ITextComponent> list = new ArrayList<ITextComponent>();
        list.add(new StringTextComponent(TextFormatting.BOLD + "" + this.getMastery().format).func_150257_a(this.getName().locName()));
        TooltipUtils.addEmpty(list);
        list.addAll(this.GetDescription(info, ctx));
        TooltipUtils.addEmpty(list);
        list.add((ITextComponent)new StringTextComponent(TextFormatting.BLUE + "Mana Cost: " + this.getCalculatedManaCost(ctx)));
        list.add((ITextComponent)new StringTextComponent(TextFormatting.YELLOW + "Cooldown: " + this.getCooldownInSeconds(ctx) + "s"));
        list.add((ITextComponent)new StringTextComponent(TextFormatting.GREEN + "Cast time: " + this.getUseDurationInSeconds(ctx) + "s"));
        TooltipUtils.addEmpty(list);
        list.add(new StringTextComponent(this.getMastery().format + "").func_150257_a(this.getMastery().getFullName()));
        TooltipUtils.addEmpty(list);
        this.immutableConfigs.castRequirements().forEach(x -> list.add(x.text));
        if (this.immutableConfigs.allowedAsRightClickOn() == AllowedAsRightClickOn.MAGE_WEAPON) {
            TooltipUtils.addEmpty(list);
            list.add((ITextComponent)new SText(TextFormatting.LIGHT_PURPLE + "Can be set as right click for a Mage Weapon"));
        }
        TooltipUtils.addEmpty(list);
        this.finishTooltip(list, ctx, info);
        return list;
    }

    public static enum AllowedAsRightClickOn {
        MAGE_WEAPON,
        MELEE_WEAPON,
        NONE;

    }
}

