/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.spells.spell_classes.bases;

import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.BaseSpell;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.configs.EntityCalcSpellConfigs;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.configs.PreCalcSpellConfigs;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.configs.SC;
import com.robertx22.mine_and_slash.saveclasses.spells.IAbility;
import com.robertx22.mine_and_slash.uncommon.capability.entity.EntityCap;
import com.robertx22.mine_and_slash.uncommon.capability.player.PlayerSpellCap;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import java.util.HashMap;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class SpellCastContext {
    public final LivingEntity caster;
    public final EntityCap.UnitData data;
    public final PlayerSpellCap.ISpellsCap spellsCap;
    public final int ticksInUse;
    public final BaseSpell spell;
    public final IAbility ability;
    public boolean isLastCastTick;
    public boolean castedThisTick = false;
    public EntityCalcSpellConfigs configForSummonedEntities;
    private HashMap<String, PreCalcSpellConfigs> cacheMap = new HashMap();

    public PreCalcSpellConfigs getConfigFor(IAbility ability) {
        if (!this.cacheMap.containsKey(ability.GUID())) {
            PreCalcSpellConfigs pre = ability.getPreCalcConfig();
            if (ability.getAbilityType() == IAbility.Type.SPELL) {
                pre.modifyBySynergies(ability.getSpell(), this.spellsCap);
                pre.modifyByUserStats(this);
            }
            this.cacheMap.put(ability.GUID(), pre);
        }
        return this.cacheMap.get(ability.GUID());
    }

    public SpellCastContext(LivingEntity caster, int ticksInUse, IAbility ability) {
        this.caster = caster;
        this.ticksInUse = ticksInUse;
        this.ability = ability;
        this.data = Load.Unit((ICapabilityProvider)caster);
        this.spellsCap = caster instanceof PlayerEntity ? Load.spells((LivingEntity)((PlayerEntity)caster)) : new PlayerSpellCap.DefaultImpl();
        this.configForSummonedEntities = new EntityCalcSpellConfigs(this.data, this.spellsCap, ability);
        this.spell = ability.getSpell();
        if (this.spell != null) {
            int castTicks = (int)this.getConfigFor(this.spell).get(SC.CAST_TIME_TICKS).get(this.spellsCap, (IAbility)this.spell);
            this.isLastCastTick = castTicks == ticksInUse;
        }
    }
}

