/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.spells.spell_classes.bases.configs;

import com.google.common.base.Preconditions;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.BaseSpell;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.SpellCastContext;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.configs.SC;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.level_based_numbers.LevelBased;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.TooltipInfo;
import com.robertx22.mine_and_slash.saveclasses.spells.IAbility;
import com.robertx22.mine_and_slash.saveclasses.spells.calc.SpellCalcData;
import com.robertx22.mine_and_slash.uncommon.capability.player.PlayerSpellCap;
import com.robertx22.mine_and_slash.uncommon.effectdatas.SpellStatsCalcEffect;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.NumberUtils;
import com.robertx22.mine_and_slash.uncommon.wrappers.SText;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class PreCalcSpellConfigs {
    private HashMap<SC, LevelBased> map = new HashMap();
    public int maxSpellLevel = 12;
    private boolean modifiedBySynergies = false;

    public PreCalcSpellConfigs() {
        this.set(SC.TIMES_TO_CAST, 1.0f, 1.0f);
        this.set(SC.COOLDOWN_TICKS, 0.0f, 0.0f);
        this.set(SC.COOLDOWN_SECONDS, 0.0f, 0.0f);
    }

    private PreCalcSpellConfigs(boolean nothing) {
    }

    public static PreCalcSpellConfigs getEmptyForSynergies() {
        return new PreCalcSpellConfigs(false);
    }

    public SpellCalcData getCalc(PlayerSpellCap.ISpellsCap cap, IAbility ability) {
        if (this.has(SC.ATTACK_SCALE_VALUE)) {
            return SpellCalcData.scaleWithAttack(this.get(SC.ATTACK_SCALE_VALUE).get(cap, ability), this.get(SC.BASE_VALUE).get(cap, ability));
        }
        if (this.has(SC.ELEMENTAL_ATTACK_SCALE_VALUE)) {
            return SpellCalcData.scaleWithElementalAttack(this.get(SC.ELEMENTAL_ATTACK_SCALE_VALUE).get(cap, ability), this.get(SC.BASE_VALUE).get(cap, ability));
        }
        if (this.has(SC.PHYSICAL_ATTACK_SCALE_VALUE)) {
            return SpellCalcData.scaleWithPhysicalAttack(this.get(SC.PHYSICAL_ATTACK_SCALE_VALUE).get(cap, ability), this.get(SC.BASE_VALUE).get(cap, ability));
        }
        if (this.has(SC.FIRE_ATTACK_SCALE_VALUE)) {
            return SpellCalcData.scaleWithFireAttack(this.get(SC.FIRE_ATTACK_SCALE_VALUE).get(cap, ability), this.get(SC.BASE_VALUE).get(cap, ability));
        }
        if (this.has(SC.WATER_ATTACK_SCALE_VALUE)) {
            return SpellCalcData.scaleWithWaterAttack(this.get(SC.WATER_ATTACK_SCALE_VALUE).get(cap, ability), this.get(SC.BASE_VALUE).get(cap, ability));
        }
        if (this.has(SC.THUNDER_ATTACK_SCALE_VALUE)) {
            return SpellCalcData.scaleWithThunderAttack(this.get(SC.THUNDER_ATTACK_SCALE_VALUE).get(cap, ability), this.get(SC.BASE_VALUE).get(cap, ability));
        }
        if (this.has(SC.NATURE_ATTACK_SCALE_VALUE)) {
            return SpellCalcData.scaleWithNatureAttack(this.get(SC.NATURE_ATTACK_SCALE_VALUE).get(cap, ability), this.get(SC.BASE_VALUE).get(cap, ability));
        }
        if (this.has(SC.ARMOR_ATTACK_SCALE_VALUE)) {
            return SpellCalcData.scaleWithArmorAttack(this.get(SC.ARMOR_ATTACK_SCALE_VALUE).get(cap, ability), this.get(SC.BASE_VALUE).get(cap, ability));
        }
        if (this.has(SC.HEALTH_ATTACK_SCALE_VALUE)) {
            return SpellCalcData.scaleWithHealthAttack(this.get(SC.HEALTH_ATTACK_SCALE_VALUE).get(cap, ability), this.get(SC.BASE_VALUE).get(cap, ability));
        }
        if (this.has(SC.ENERGY_ATTACK_SCALE_VALUE)) {
            return SpellCalcData.scaleWithEnergyAttack(this.get(SC.ENERGY_ATTACK_SCALE_VALUE).get(cap, ability), this.get(SC.BASE_VALUE).get(cap, ability));
        }
        if (this.has(SC.MANA_ATTACK_SCALE_VALUE)) {
            return SpellCalcData.scaleWithManaAttack(this.get(SC.MANA_ATTACK_SCALE_VALUE).get(cap, ability), this.get(SC.BASE_VALUE).get(cap, ability));
        }
        return SpellCalcData.base(this.get(SC.BASE_VALUE).get(cap, ability));
    }

    public boolean has(SC sc) {
        return this.map.containsKey((Object)sc);
    }

    public HashMap<SC, LevelBased> getMap() {
        return this.map;
    }

    public void set(SC sc, float min, float max) {
        this.map.put(sc, new LevelBased(min, max).min(sc.min));
    }

    public void setDurationInSeconds(int s1, int s2) {
        this.set(SC.DURATION_TICKS, s1 * 20, s2 * 20);
    }

    public void multiplyValueBy(SC sc, float multi) {
        this.get(sc).multiplyBy(multi);
    }

    public void setMaxLevel(int lvl) {
        this.maxSpellLevel = lvl;
    }

    public LevelBased getOrEmpty(SC sc) {
        if (this.has(sc)) {
            return this.get(sc);
        }
        return LevelBased.empty();
    }

    public LevelBased get(SC sc) {
        if (!this.map.containsKey((Object)sc)) {
            try {
                throw new Exception("Trying to get non existent value: " + sc.name());
            }
            catch (Exception e) {
                e.printStackTrace();
                return LevelBased.empty();
            }
        }
        LevelBased thing = this.map.get((Object)sc);
        if (thing.isEmpty()) {
            try {
                throw new Exception("Getting empty value: " + sc.name());
            }
            catch (Exception e) {
                e.printStackTrace();
                return LevelBased.empty();
            }
        }
        return thing;
    }

    public void modifyByUserStats(SpellCastContext ctx) {
        new SpellStatsCalcEffect(ctx, this, ctx.caster, ctx.caster).Activate();
    }

    public void modifyBySynergies(BaseSpell spell, PlayerSpellCap.ISpellsCap cap) {
        Preconditions.checkArgument((!this.modifiedBySynergies ? 1 : 0) != 0, (Object)"Cannot modify same spell calc config instance twice with synergies!,Make sure you're returning new config instances on each method call!!!");
        spell.getAllocatedSynergies(cap).forEach(x -> {
            PreCalcSpellConfigs sc = x.getConfigsAffectingSpell();
            sc.map.entrySet().forEach(e -> this.map.get(e.getKey()).modifyBy((LevelBased)e.getValue()));
        });
        this.modifiedBySynergies = true;
    }

    public List<ITextComponent> GetTooltipString(TooltipInfo info, SpellCastContext ctx) {
        ArrayList<ITextComponent> list = new ArrayList<ITextComponent>();
        if (Screen.hasShiftDown()) {
            this.map.entrySet().forEach(x -> {
                if (((SC)((Object)((Object)x.getKey()))).shouldAddToTooltip()) {
                    String val = NumberUtils.trimFloat(((LevelBased)x.getValue()).get(ctx.spellsCap, ctx.ability));
                    list.add(new SText(TextFormatting.GRAY + "").func_150257_a(((SC)((Object)((Object)x.getKey()))).word.locName()).func_150258_a(": " + TextFormatting.GREEN + val));
                }
            });
        }
        return list;
    }
}

