/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.spells.spell_classes.divine;

import com.robertx22.mine_and_slash.database.spells.entities.proj.GroundSlamEntity;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.BaseSpell;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.SpellCastContext;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.cast_types.SpellCastType;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.configs.ImmutableSpellConfigs;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.configs.PreCalcSpellConfigs;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.configs.SC;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.TooltipInfo;
import com.robertx22.mine_and_slash.saveclasses.spells.AbilityPlace;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Elements;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Masteries;
import com.robertx22.mine_and_slash.uncommon.localization.Words;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;

public class GroundSlamSpell
extends BaseSpell {
    private GroundSlamSpell() {
        super(new ImmutableSpellConfigs(){

            @Override
            public Masteries school() {
                return Masteries.DIVINE;
            }

            @Override
            public SpellCastType castType() {
                return SpellCastType.PROJECTILE;
            }

            @Override
            public SoundEvent sound() {
                return SoundEvents.field_187692_g;
            }

            @Override
            public Elements element() {
                return Elements.Physical;
            }
        }.cooldownIfCanceled(true).rightClickFor(BaseSpell.AllowedAsRightClickOn.MELEE_WEAPON).summonsEntity(w -> new GroundSlamEntity((World)w)).setSwingArmOnCast());
    }

    @Override
    public PreCalcSpellConfigs getPreCalcConfig() {
        PreCalcSpellConfigs c = new PreCalcSpellConfigs();
        c.set(SC.MANA_COST, 14.0f, 20.0f);
        c.set(SC.BASE_VALUE, 0.0f, 0.0f);
        c.set(SC.ARMOR_ATTACK_SCALE_VALUE, 0.5f, 0.8f);
        c.set(SC.SHOOT_SPEED, 1.2f, 1.6f);
        c.set(SC.PROJECTILE_COUNT, 3.0f, 5.0f);
        c.set(SC.CAST_TIME_TICKS, 0.0f, 0.0f);
        c.set(SC.COOLDOWN_TICKS, 240.0f, 160.0f);
        c.set(SC.TIMES_TO_CAST, 1.0f, 1.0f);
        c.set(SC.DURATION_TICKS, 40.0f, 60.0f);
        c.setMaxLevel(12);
        return c;
    }

    public static GroundSlamSpell getInstance() {
        return SingletonHolder.INSTANCE;
    }

    @Override
    public AbilityPlace getAbilityPlace() {
        return new AbilityPlace(5, 3);
    }

    @Override
    public String GUID() {
        return "ground_slam";
    }

    @Override
    public List<ITextComponent> GetDescription(TooltipInfo info, SpellCastContext ctx) {
        ArrayList<ITextComponent> list = new ArrayList<ITextComponent>();
        list.add((ITextComponent)new StringTextComponent("Converts armor to damage, retribute"));
        list.add((ITextComponent)new StringTextComponent("to damage enemies in front of you: "));
        list.addAll(this.getCalculation(ctx).GetTooltipString(info, ctx));
        return list;
    }

    @Override
    public Words getName() {
        return Words.GroundSlam;
    }

    private static class SingletonHolder {
        private static final GroundSlamSpell INSTANCE = new GroundSlamSpell();

        private SingletonHolder() {
        }
    }
}

