/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.spells.spell_classes.divine;

import com.robertx22.mine_and_slash.database.spells.SpellUtils;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.BaseSpell;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.SpellCastContext;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.cast_types.SpellCastType;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.configs.ImmutableSpellConfigs;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.configs.PreCalcSpellConfigs;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.configs.SC;
import com.robertx22.mine_and_slash.packets.particles.ParticleEnum;
import com.robertx22.mine_and_slash.packets.particles.ParticlePacketData;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.TooltipInfo;
import com.robertx22.mine_and_slash.saveclasses.spells.AbilityPlace;
import com.robertx22.mine_and_slash.saveclasses.spells.IAbility;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Elements;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Masteries;
import com.robertx22.mine_and_slash.uncommon.localization.Words;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.EntityFinder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.LivingEntity;
import net.minecraft.particles.ParticleType;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class HealingAuraSpell
extends BaseSpell {
    private HealingAuraSpell() {
        super(new ImmutableSpellConfigs(){

            @Override
            public Masteries school() {
                return Masteries.DIVINE;
            }

            @Override
            public SpellCastType castType() {
                return SpellCastType.SELF_HEAL;
            }

            @Override
            public SoundEvent sound() {
                return SoundEvents.field_193780_J;
            }

            @Override
            public Elements element() {
                return Elements.Elemental;
            }
        }.setSwingArmOnCast());
    }

    @Override
    public void castExtra(SpellCastContext ctx) {
        float RADIUS = ctx.getConfigFor(this).get(SC.RADIUS).get(ctx.spellsCap, (IAbility)this);
        List<LivingEntity> list = EntityFinder.start(ctx.caster, LivingEntity.class, ctx.caster.func_174791_d()).finder(EntityFinder.Finder.RADIUS).radius(RADIUS).searchFor(EntityFinder.SearchFor.ALLIES).build();
        for (LivingEntity en : list) {
            int num = ctx.getConfigFor(this).getCalc(ctx.spellsCap, this).getCalculatedValue(ctx.data, ctx.spellsCap, this);
            SpellUtils.heal(this, en, num);
            ParticleEnum.sendToClients(en.func_180425_c(), en.field_70170_p, new ParticlePacketData(en.func_174791_d(), ParticleEnum.AOE).radius(RADIUS).motion(new Vec3d(0.0, 0.0, 0.0)).type((ParticleType)ParticleTypes.field_229428_ah_).amount(90));
            ParticleEnum.sendToClients(en.func_180425_c(), en.field_70170_p, new ParticlePacketData(en.func_174791_d(), ParticleEnum.AOE).radius(RADIUS).motion(new Vec3d(0.0, 0.0, 0.0)).type((ParticleType)ParticleTypes.field_197633_z).amount(45));
        }
    }

    @Override
    public PreCalcSpellConfigs getPreCalcConfig() {
        PreCalcSpellConfigs c = new PreCalcSpellConfigs();
        c.set(SC.MANA_COST, 4.0f, 9.0f);
        c.set(SC.BASE_VALUE, 4.0f, 14.0f);
        c.set(SC.CAST_TIME_TICKS, 20.0f, 10.0f);
        c.set(SC.COOLDOWN_SECONDS, 4.0f, 2.0f);
        c.set(SC.TIMES_TO_CAST, 1.0f, 1.0f);
        c.set(SC.RADIUS, 3.0f, 6.0f);
        c.setMaxLevel(16);
        return c;
    }

    public static HealingAuraSpell getInstance() {
        return SingletonHolder.INSTANCE;
    }

    @Override
    public AbilityPlace getAbilityPlace() {
        return new AbilityPlace(0, 0);
    }

    @Override
    public String GUID() {
        return "healing_aura";
    }

    @Override
    public List<ITextComponent> GetDescription(TooltipInfo info, SpellCastContext ctx) {
        ArrayList<ITextComponent> list = new ArrayList<ITextComponent>();
        list.add((ITextComponent)new StringTextComponent("Heal everyone around you: "));
        list.addAll(this.getCalculation(ctx).GetTooltipString(info, ctx));
        return list;
    }

    @Override
    public Words getName() {
        return Words.HealingAura;
    }

    private static class SingletonHolder {
        private static final HealingAuraSpell INSTANCE = new HealingAuraSpell();

        private SingletonHolder() {
        }
    }
}

