/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.spells.spell_classes.divine;

import com.robertx22.mine_and_slash.database.spells.entities.trident.SpearOfJudgementEntity;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.BaseSpell;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.SpellCastContext;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.cast_types.SpellCastType;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.configs.ImmutableSpellConfigs;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.configs.PreCalcSpellConfigs;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.configs.SC;
import com.robertx22.mine_and_slash.potion_effects.divine.JudgementEffect;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.TooltipInfo;
import com.robertx22.mine_and_slash.saveclasses.spells.AbilityPlace;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Elements;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Masteries;
import com.robertx22.mine_and_slash.uncommon.localization.Words;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;

public class SpearOfJudgementSpell
extends BaseSpell {
    private SpearOfJudgementSpell() {
        super(new ImmutableSpellConfigs(){

            @Override
            public Masteries school() {
                return Masteries.DIVINE;
            }

            @Override
            public SpellCastType castType() {
                return SpellCastType.PROJECTILE;
            }

            @Override
            public SoundEvent sound() {
                return SoundEvents.field_187646_bt;
            }

            @Override
            public Elements element() {
                return Elements.Thunder;
            }
        }.summonsEntity(x -> new SpearOfJudgementEntity((World)x)).setSwingArmOnCast());
    }

    public static SpearOfJudgementSpell getInstance() {
        return SingletonHolder.INSTANCE;
    }

    @Override
    public PreCalcSpellConfigs getPreCalcConfig() {
        PreCalcSpellConfigs c = new PreCalcSpellConfigs();
        c.set(SC.MANA_COST, 12.0f, 18.0f);
        c.set(SC.BASE_VALUE, 6.0f, 15.0f);
        c.set(SC.ATTACK_SCALE_VALUE, 0.5f, 0.75f);
        c.set(SC.CAST_TIME_TICKS, 0.0f, 0.0f);
        c.set(SC.COOLDOWN_SECONDS, 14.0f, 10.0f);
        c.set(SC.TIMES_TO_CAST, 1.0f, 1.0f);
        c.set(SC.SHOOT_SPEED, 1.8f, 3.0f);
        c.set(SC.DURATION_TICKS, 100.0f, 120.0f);
        c.set(SC.PROJECTILE_COUNT, 1.0f, 1.0f);
        c.set(SC.TICK_RATE, 10.0f, 10.0f);
        c.setMaxLevel(8);
        return c;
    }

    @Override
    public AbilityPlace getAbilityPlace() {
        return new AbilityPlace(3, 5);
    }

    @Override
    public String GUID() {
        return "spear_of_judgement";
    }

    @Override
    public List<ITextComponent> GetDescription(TooltipInfo info, SpellCastContext ctx) {
        ArrayList<ITextComponent> list = new ArrayList<ITextComponent>();
        list.add((ITextComponent)new StringTextComponent("Converts Weapon DMG to Thunder and"));
        list.add((ITextComponent)new StringTextComponent("throws out a spear that deals damage"));
        list.add((ITextComponent)new StringTextComponent("which applies Judgment: "));
        list.addAll(JudgementEffect.INSTANCE.GetTooltipStringWithNoExtraSpellInfo(info));
        return list;
    }

    @Override
    public Words getName() {
        return Words.SpearOfJudgement;
    }

    private static class SingletonHolder {
        private static final SpearOfJudgementSpell INSTANCE = new SpearOfJudgementSpell();

        private SingletonHolder() {
        }
    }
}

