/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.spells.spell_classes.divine;

import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.BaseSpell;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.SpellCastContext;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.cast_types.SpellCastType;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.configs.ImmutableSpellConfigs;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.configs.PreCalcSpellConfigs;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.configs.SC;
import com.robertx22.mine_and_slash.packets.particles.ParticleEnum;
import com.robertx22.mine_and_slash.packets.particles.ParticlePacketData;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.TooltipInfo;
import com.robertx22.mine_and_slash.saveclasses.spells.AbilityPlace;
import com.robertx22.mine_and_slash.saveclasses.spells.IAbility;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.effectdatas.DamageEffect;
import com.robertx22.mine_and_slash.uncommon.effectdatas.EffectData;
import com.robertx22.mine_and_slash.uncommon.effectdatas.interfaces.WeaponTypes;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Elements;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Masteries;
import com.robertx22.mine_and_slash.uncommon.localization.Words;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.EntityFinder;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.SoundUtils;
import com.robertx22.mine_and_slash.uncommon.wrappers.SText;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class WhirlwindSpell
extends BaseSpell {
    private WhirlwindSpell() {
        super(new ImmutableSpellConfigs(){

            @Override
            public Masteries school() {
                return Masteries.DIVINE;
            }

            @Override
            public SpellCastType castType() {
                return SpellCastType.SPECIAL;
            }

            @Override
            public SoundEvent sound() {
                return SoundEvents.field_187730_dW;
            }

            @Override
            public Elements element() {
                return Elements.Physical;
            }
        }.cooldownIfCanceled(true));
    }

    @Override
    public PreCalcSpellConfigs getPreCalcConfig() {
        PreCalcSpellConfigs c = new PreCalcSpellConfigs();
        c.set(SC.MANA_COST, 18.0f, 25.0f);
        c.set(SC.BASE_VALUE, 0.0f, 0.0f);
        c.set(SC.ATTACK_SCALE_VALUE, 0.45f, 0.6f);
        c.set(SC.CAST_TIME_TICKS, 100.0f, 260.0f);
        c.set(SC.COOLDOWN_SECONDS, 60.0f, 45.0f);
        c.set(SC.RADIUS, 1.0f, 3.0f);
        c.set(SC.TIMES_TO_CAST, 20.0f, 80.0f);
        c.setMaxLevel(8);
        return c;
    }

    @Override
    public AbilityPlace getAbilityPlace() {
        return new AbilityPlace(7, 4);
    }

    public static WhirlwindSpell getInstance() {
        return SingletonHolder.INSTANCE;
    }

    @Override
    public String GUID() {
        return "whirlwind";
    }

    @Override
    public List<ITextComponent> GetDescription(TooltipInfo info, SpellCastContext ctx) {
        ArrayList<ITextComponent> list = new ArrayList<ITextComponent>();
        list.add((ITextComponent)new SText("Spin to do damage to enemies around you: "));
        list.addAll(this.getCalculation(ctx).GetTooltipString(info, ctx));
        return list;
    }

    public void damageMobsAroundYou(SpellCastContext ctx, LivingEntity caster) {
        if (!caster.field_70170_p.field_72995_K) {
            float radius = ctx.getConfigFor(this).get(SC.RADIUS).get(ctx.spellsCap, (IAbility)this);
            ParticlePacketData pdata = new ParticlePacketData(caster.func_180425_c().func_177981_b(1), ParticleEnum.WHIRLWIND);
            pdata.radius = radius;
            ParticleEnum.sendToClients((Entity)caster, pdata);
            int num = this.getCalculation(ctx).getCalculatedValue(Load.Unit((ICapabilityProvider)caster), ctx.spellsCap, ctx.ability);
            List<LivingEntity> entities = EntityFinder.start(caster, LivingEntity.class, caster.func_174791_d()).radius(radius).build();
            for (LivingEntity en : entities) {
                DamageEffect dmg = new DamageEffect(null, caster, en, num, EffectData.EffectTypes.SPELL, WeaponTypes.None);
                dmg.element = Elements.Physical;
                dmg.removeKnockback();
                dmg.Activate();
            }
        }
    }

    @Override
    public Words getName() {
        return Words.Whirlwind;
    }

    @Override
    public void castExtra(SpellCastContext ctx) {
        this.damageMobsAroundYou(ctx, ctx.caster);
        SoundUtils.playSound((Entity)ctx.caster, SoundEvents.field_187730_dW, 0.7f, 2.0f);
    }

    private static class SingletonHolder {
        private static final WhirlwindSpell INSTANCE = new WhirlwindSpell();

        private SingletonHolder() {
        }
    }
}

