/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.spells.spell_classes.divine.buffs;

import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.BaseSpell;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.SpellCastContext;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.configs.ImmutableSpellConfigs;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.configs.PreCalcSpellConfigs;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.configs.SC;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.TooltipInfo;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public abstract class BaseDivineBuffSpell
extends BaseSpell {
    public BaseDivineBuffSpell(ImmutableSpellConfigs configs) {
        super(configs.setSwingArmOnCast());
    }

    @Override
    public PreCalcSpellConfigs getPreCalcConfig() {
        PreCalcSpellConfigs c = new PreCalcSpellConfigs();
        c.set(SC.MANA_COST, 35.0f, 45.0f);
        c.set(SC.CAST_TIME_TICKS, 160.0f, 220.0f);
        c.set(SC.COOLDOWN_SECONDS, 120.0f, 90.0f);
        c.set(SC.DURATION_TICKS, 12000.0f, 18000.0f);
        c.set(SC.RADIUS, 6.0f, 10.0f);
        c.setMaxLevel(10);
        return c;
    }

    @Override
    public List<ITextComponent> GetDescription(TooltipInfo info, SpellCastContext ctx) {
        ArrayList<ITextComponent> list = new ArrayList<ITextComponent>();
        list.add((ITextComponent)new StringTextComponent("Applies aura to all nearby allies: "));
        list.addAll(this.getImmutableConfigs().potionEffect().GetTooltipStringWithNoExtraSpellInfo(info));
        list.add((ITextComponent)new StringTextComponent("Only one Divine aura is allowed at a time! "));
        return list;
    }
}

