/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.spells.spell_classes.fire;

import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.BaseSpell;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.SpellCastContext;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.cast_types.SpellCastType;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.configs.ImmutableSpellConfigs;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.configs.PreCalcSpellConfigs;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.configs.SC;
import com.robertx22.mine_and_slash.packets.particles.ParticleEnum;
import com.robertx22.mine_and_slash.packets.particles.ParticlePacketData;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.TooltipInfo;
import com.robertx22.mine_and_slash.saveclasses.spells.AbilityPlace;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.effectdatas.SpellDamageEffect;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Elements;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Masteries;
import com.robertx22.mine_and_slash.uncommon.localization.Words;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.EntityFinder;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.SoundUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.ParticleType;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class FlameBlitzSpell
extends BaseSpell {
    private FlameBlitzSpell() {
        super(new ImmutableSpellConfigs(){

            @Override
            public Masteries school() {
                return Masteries.FIRE;
            }

            @Override
            public SpellCastType castType() {
                return SpellCastType.SPECIAL;
            }

            @Override
            public SoundEvent sound() {
                return SoundEvents.field_187646_bt;
            }

            @Override
            public Elements element() {
                return Elements.Fire;
            }
        }.cooldownIfCanceled(true).rightClickFor(BaseSpell.AllowedAsRightClickOn.MELEE_WEAPON).setSwingArmOnCast());
    }

    @Override
    public void castExtra(SpellCastContext ctx) {
        if (ctx.caster instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)ctx.caster;
            player.func_184810_cG();
        }
        ctx.caster.field_70170_p.func_184148_a((PlayerEntity)null, ctx.caster.func_226277_ct_(), ctx.caster.func_226278_cu_(), ctx.caster.func_226281_cx_(), SoundEvents.field_187730_dW, SoundCategory.PLAYERS, 1.0f, 1.0f);
        Vec3d look = ctx.caster.func_70040_Z().func_186678_a(3.0);
        List<LivingEntity> list = EntityFinder.start(ctx.caster, LivingEntity.class, ctx.caster.func_174791_d().func_178787_e(look).func_72441_c(0.0, (double)(ctx.caster.func_213302_cg() / 2.0f), 0.0)).finder(EntityFinder.Finder.RADIUS).radius(2.0).height(2.0).build();
        SoundUtils.playSound((Entity)ctx.caster, SoundEvents.field_187646_bt, 1.0f, 1.0f);
        for (LivingEntity en : list) {
            int num = ctx.getConfigFor(this).getCalc(ctx.spellsCap, this).getCalculatedValue(ctx.data, ctx.spellsCap, this);
            SpellDamageEffect dmg = new SpellDamageEffect(ctx.caster, en, num, ctx.data, Load.Unit((ICapabilityProvider)en), this);
            dmg.Activate();
            ParticleEnum.sendToClients(en.func_180425_c(), en.field_70170_p, new ParticlePacketData(en.func_174791_d(), ParticleEnum.AOE).radius(1.0f).motion(new Vec3d(0.0, 0.0, 0.0)).type((ParticleType)ParticleTypes.field_197631_x).amount(60));
        }
    }

    public static FlameBlitzSpell getInstance() {
        return SingletonHolder.INSTANCE;
    }

    @Override
    public PreCalcSpellConfigs getPreCalcConfig() {
        PreCalcSpellConfigs c = new PreCalcSpellConfigs();
        c.set(SC.MANA_COST, 5.0f, 17.0f);
        c.set(SC.BASE_VALUE, 2.0f, 3.0f);
        c.set(SC.ATTACK_SCALE_VALUE, 0.5f, 0.7f);
        c.set(SC.CAST_TIME_TICKS, 40.0f, 80.0f);
        c.set(SC.COOLDOWN_SECONDS, 10.0f, 8.0f);
        c.set(SC.TIMES_TO_CAST, 4.0f, 8.0f);
        c.setMaxLevel(16);
        return c;
    }

    @Override
    public AbilityPlace getAbilityPlace() {
        return new AbilityPlace(5, 0);
    }

    @Override
    public String GUID() {
        return "flame_blitz";
    }

    @Override
    public List<ITextComponent> GetDescription(TooltipInfo info, SpellCastContext ctx) {
        ArrayList<ITextComponent> list = new ArrayList<ITextComponent>();
        list.add((ITextComponent)new StringTextComponent("Converts Weapon DMG to Fire and"));
        list.add((ITextComponent)new StringTextComponent("rapidly strikes enemies in melee: "));
        list.addAll(this.getCalculation(ctx).GetTooltipString(info, ctx));
        return list;
    }

    @Override
    public Words getName() {
        return Words.FlameBlitz;
    }

    private static class SingletonHolder {
        private static final FlameBlitzSpell INSTANCE = new FlameBlitzSpell();

        private SingletonHolder() {
        }
    }
}

