/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.spells.spell_classes.fire;

import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.BaseSpell;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.SpellCastContext;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.cast_types.SpellCastType;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.configs.ImmutableSpellConfigs;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.configs.PreCalcSpellConfigs;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.configs.SC;
import com.robertx22.mine_and_slash.potion_effects.ember_mage.SpellBladeEffect;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.TooltipInfo;
import com.robertx22.mine_and_slash.saveclasses.spells.AbilityPlace;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Elements;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Masteries;
import com.robertx22.mine_and_slash.uncommon.localization.Words;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.ParticleUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.particles.ParticleType;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class SpellBladeSpell
extends BaseSpell {
    private SpellBladeSpell() {
        super(new ImmutableSpellConfigs(){

            @Override
            public Masteries school() {
                return Masteries.FIRE;
            }

            @Override
            public SpellCastType castType() {
                return SpellCastType.GIVE_EFFECT;
            }

            @Override
            public SoundEvent sound() {
                return SoundEvents.field_190021_aL;
            }

            @Override
            public Elements element() {
                return Elements.Fire;
            }
        }.addsEffect(SpellBladeEffect.INSTANCE).setSwingArmOnCast());
    }

    @Override
    public PreCalcSpellConfigs getPreCalcConfig() {
        PreCalcSpellConfigs c = new PreCalcSpellConfigs();
        c.set(SC.MANA_COST, 12.0f, 15.0f);
        c.set(SC.CAST_TIME_TICKS, 0.0f, 0.0f);
        c.set(SC.COOLDOWN_SECONDS, 40.0f, 30.0f);
        c.set(SC.DURATION_TICKS, 200.0f, 400.0f);
        c.setMaxLevel(8);
        return c;
    }

    public static SpellBladeSpell getInstance() {
        return SingletonHolder.INSTANCE;
    }

    @Override
    public String GUID() {
        return "spell_blade";
    }

    @Override
    public List<ITextComponent> GetDescription(TooltipInfo info, SpellCastContext ctx) {
        ArrayList<ITextComponent> list = new ArrayList<ITextComponent>();
        list.add((ITextComponent)new StringTextComponent("Applies buff: "));
        list.addAll(SpellBladeEffect.INSTANCE.GetTooltipStringWithNoExtraSpellInfo(info));
        return list;
    }

    @Override
    public Words getName() {
        return Words.SpellBlade;
    }

    @Override
    public void spawnParticles(SpellCastContext ctx) {
        if (ctx.caster.field_70170_p.field_72995_K) {
            ParticleUtils.spawnParticles((ParticleType)ParticleTypes.field_197631_x, ctx.caster, 20);
            ParticleUtils.spawnParticles((ParticleType)ParticleTypes.field_197607_R, ctx.caster, 10);
        }
    }

    @Override
    public AbilityPlace getAbilityPlace() {
        return new AbilityPlace(6, 2);
    }

    private static class SingletonHolder {
        private static final SpellBladeSpell INSTANCE = new SpellBladeSpell();

        private SingletonHolder() {
        }
    }
}

