/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.spells.spell_classes.fire;

import com.robertx22.mine_and_slash.database.spells.entities.proj.ThrowFlameEntity;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.BaseSpell;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.SpellCastContext;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.cast_types.SpellCastType;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.configs.ImmutableSpellConfigs;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.configs.PreCalcSpellConfigs;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.configs.SC;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.TooltipInfo;
import com.robertx22.mine_and_slash.saveclasses.spells.AbilityPlace;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Elements;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Masteries;
import com.robertx22.mine_and_slash.uncommon.localization.Words;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;

public class ThrowFlamesSpell
extends BaseSpell {
    private ThrowFlamesSpell() {
        super(new ImmutableSpellConfigs(){

            @Override
            public Masteries school() {
                return Masteries.FIRE;
            }

            @Override
            public SpellCastType castType() {
                return SpellCastType.PROJECTILE;
            }

            @Override
            public SoundEvent sound() {
                return SoundEvents.field_187541_bC;
            }

            @Override
            public Elements element() {
                return Elements.Fire;
            }
        }.cooldownIfCanceled(true).summonsEntity(w -> new ThrowFlameEntity((World)w)).setSwingArmOnCast());
    }

    public static ThrowFlamesSpell getInstance() {
        return SingletonHolder.INSTANCE;
    }

    @Override
    public PreCalcSpellConfigs getPreCalcConfig() {
        PreCalcSpellConfigs c = new PreCalcSpellConfigs();
        c.set(SC.MANA_COST, 11.0f, 16.0f);
        c.set(SC.BASE_VALUE, 3.0f, 5.0f);
        c.set(SC.FIRE_ATTACK_SCALE_VALUE, 0.55f, 0.7f);
        c.set(SC.SHOOT_SPEED, 1.0f, 1.25f);
        c.set(SC.PROJECTILE_COUNT, 3.0f, 3.0f);
        c.set(SC.CAST_TIME_TICKS, 0.0f, 0.0f);
        c.set(SC.COOLDOWN_SECONDS, 14.0f, 11.0f);
        c.set(SC.DURATION_TICKS, 60.0f, 60.0f);
        c.set(SC.TIMES_TO_CAST, 1.0f, 1.0f);
        c.setMaxLevel(12);
        return c;
    }

    @Override
    public AbilityPlace getAbilityPlace() {
        return new AbilityPlace(7, 4);
    }

    @Override
    public String GUID() {
        return "throw_flames";
    }

    @Override
    public List<ITextComponent> GetDescription(TooltipInfo info, SpellCastContext ctx) {
        ArrayList<ITextComponent> list = new ArrayList<ITextComponent>();
        list.add((ITextComponent)new StringTextComponent("Converts Weapon DMG to Fire."));
        list.add((ITextComponent)new StringTextComponent("Strike the air in front of you, sending out fiery waves: "));
        list.addAll(this.getCalculation(ctx).GetTooltipString(info, ctx));
        return list;
    }

    @Override
    public Words getName() {
        return Words.ThrowFlames;
    }

    @Override
    public void castExtra(SpellCastContext ctx) {
        if (ctx.caster instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)ctx.caster;
            player.func_184810_cG();
        }
        ctx.caster.field_70170_p.func_184148_a((PlayerEntity)null, ctx.caster.func_226277_ct_(), ctx.caster.func_226278_cu_(), ctx.caster.func_226281_cx_(), SoundEvents.field_187730_dW, SoundCategory.PLAYERS, 1.0f, 1.0f);
    }

    private static class SingletonHolder {
        private static final ThrowFlamesSpell INSTANCE = new ThrowFlamesSpell();

        private SingletonHolder() {
        }
    }
}

