/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.spells.spell_classes.fire;

import com.robertx22.mine_and_slash.database.spells.entities.cloud.VolcanoEntity;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.BaseSpell;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.SpellCastContext;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.cast_types.SpellCastType;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.configs.ImmutableSpellConfigs;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.configs.PreCalcSpellConfigs;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.configs.SC;
import com.robertx22.mine_and_slash.mmorpg.registers.common.ModSounds;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.TooltipInfo;
import com.robertx22.mine_and_slash.saveclasses.spells.AbilityPlace;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Elements;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Masteries;
import com.robertx22.mine_and_slash.uncommon.localization.Words;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;

public class VolcanoSpell
extends BaseSpell {
    private VolcanoSpell() {
        super(new ImmutableSpellConfigs(){

            @Override
            public Masteries school() {
                return Masteries.FIRE;
            }

            @Override
            public SpellCastType castType() {
                return SpellCastType.AT_SIGHT;
            }

            @Override
            public SoundEvent sound() {
                return (SoundEvent)ModSounds.FIREBALL.get();
            }

            @Override
            public Elements element() {
                return Elements.Fire;
            }
        }.summonsEntity(world -> new VolcanoEntity((World)world)).setSwingArmOnCast());
    }

    @Override
    public PreCalcSpellConfigs getPreCalcConfig() {
        PreCalcSpellConfigs c = new PreCalcSpellConfigs();
        c.set(SC.MANA_COST, 30.0f, 50.0f);
        c.set(SC.BASE_VALUE, 6.0f, 15.0f);
        c.set(SC.FIRE_ATTACK_SCALE_VALUE, 0.35f, 0.55f);
        c.set(SC.CAST_TIME_TICKS, 90.0f, 60.0f);
        c.set(SC.COOLDOWN_SECONDS, 60.0f, 45.0f);
        c.set(SC.RADIUS, 3.0f, 6.0f);
        c.set(SC.DURATION_TICKS, 120.0f, 200.0f);
        c.set(SC.TICK_RATE, 20.0f, 15.0f);
        c.setMaxLevel(8);
        return c;
    }

    @Override
    public AbilityPlace getAbilityPlace() {
        return new AbilityPlace(4, 5);
    }

    public static VolcanoSpell getInstance() {
        return SingletonHolder.INSTANCE;
    }

    @Override
    public String GUID() {
        return "volcano";
    }

    @Override
    public List<ITextComponent> GetDescription(TooltipInfo info, SpellCastContext ctx) {
        ArrayList<ITextComponent> list = new ArrayList<ITextComponent>();
        list.add((ITextComponent)new StringTextComponent("Summons an erupting volcano: "));
        list.addAll(this.getCalculation(ctx).GetTooltipString(info, ctx));
        return list;
    }

    @Override
    public Words getName() {
        return Words.Volcano;
    }

    private static class SingletonHolder {
        private static final VolcanoSpell INSTANCE = new VolcanoSpell();

        private SingletonHolder() {
        }
    }
}

