/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.spells.spell_classes.hunting;

import com.robertx22.mine_and_slash.database.spells.entities.proj.RangerArrowEntity;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.BaseSpell;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.SpellCastContext;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.SpellPredicates;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.cast_types.SpellCastType;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.configs.ImmutableSpellConfigs;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.configs.PreCalcSpellConfigs;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.configs.SC;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.TooltipInfo;
import com.robertx22.mine_and_slash.saveclasses.spells.AbilityPlace;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Elements;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Masteries;
import com.robertx22.mine_and_slash.uncommon.localization.Words;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;

public class ArrowBarrageSpell
extends BaseSpell {
    private ArrowBarrageSpell() {
        super(new ImmutableSpellConfigs(){

            @Override
            public Masteries school() {
                return Masteries.HUNTING;
            }

            @Override
            public SpellCastType castType() {
                return SpellCastType.PROJECTILE;
            }

            @Override
            public SoundEvent sound() {
                return SoundEvents.field_187737_v;
            }

            @Override
            public Elements element() {
                return Elements.Elemental;
            }
        }.addCastRequirement(SpellPredicates.REQUIRE_SHOOTABLE).cooldownIfCanceled(true).summonsEntity(world -> new RangerArrowEntity((World)world)));
    }

    @Override
    public PreCalcSpellConfigs getPreCalcConfig() {
        PreCalcSpellConfigs c = new PreCalcSpellConfigs();
        c.set(SC.MANA_COST, 8.0f, 16.0f);
        c.set(SC.BASE_VALUE, 1.0f, 4.0f);
        c.set(SC.ATTACK_SCALE_VALUE, 1.25f, 2.5f);
        c.set(SC.PROJECTILE_COUNT, 1.0f, 1.0f);
        c.set(SC.SHOOT_SPEED, 2.5f, 3.75f);
        c.set(SC.CAST_TIME_TICKS, 40.0f, 40.0f);
        c.set(SC.COOLDOWN_SECONDS, 12.0f, 8.0f);
        c.set(SC.TIMES_TO_CAST, 4.0f, 8.0f);
        c.set(SC.DURATION_TICKS, 100.0f, 160.0f);
        c.setMaxLevel(16);
        return c;
    }

    @Override
    public AbilityPlace getAbilityPlace() {
        return new AbilityPlace(0, 0);
    }

    public static ArrowBarrageSpell getInstance() {
        return SingletonHolder.INSTANCE;
    }

    @Override
    public String GUID() {
        return "arrow_barrage";
    }

    @Override
    public List<ITextComponent> GetDescription(TooltipInfo info, SpellCastContext ctx) {
        ArrayList<ITextComponent> list = new ArrayList<ITextComponent>();
        list.add((ITextComponent)new StringTextComponent("Shoots out many arrows while casting."));
        list.add((ITextComponent)new StringTextComponent("Requires Bow/Crossbow to use: "));
        list.addAll(this.getCalculation(ctx).GetTooltipString(info, ctx));
        return list;
    }

    @Override
    public Words getName() {
        return Words.ArrowBarrage;
    }

    private static class SingletonHolder {
        private static final ArrowBarrageSpell INSTANCE = new ArrowBarrageSpell();

        private SingletonHolder() {
        }
    }
}

