/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.spells.spell_classes.hunting;

import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.BaseSpell;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.SpellCastContext;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.cast_types.SpellCastType;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.configs.ImmutableSpellConfigs;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.configs.PreCalcSpellConfigs;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.configs.SC;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.TooltipInfo;
import com.robertx22.mine_and_slash.saveclasses.spells.AbilityPlace;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Elements;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Masteries;
import com.robertx22.mine_and_slash.uncommon.localization.Words;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.ParticleUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.particles.ParticleType;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class HuntingPotionSpell
extends BaseSpell {
    private HuntingPotionSpell() {
        super(new ImmutableSpellConfigs(){

            @Override
            public Masteries school() {
                return Masteries.HUNTING;
            }

            @Override
            public SpellCastType castType() {
                return SpellCastType.SELF_HEAL;
            }

            @Override
            public SoundEvent sound() {
                return SoundEvents.field_219712_mX;
            }

            @Override
            public Elements element() {
                return Elements.Elemental;
            }
        });
    }

    @Override
    public PreCalcSpellConfigs getPreCalcConfig() {
        PreCalcSpellConfigs c = new PreCalcSpellConfigs();
        c.set(SC.MANA_COST, 0.0f, 0.0f);
        c.set(SC.CAST_TIME_TICKS, 0.0f, 0.0f);
        c.set(SC.BASE_VALUE, 1.0f, 4.0f);
        c.set(SC.HEALTH_ATTACK_SCALE_VALUE, 0.35f, 0.7f);
        c.set(SC.COOLDOWN_SECONDS, 120.0f, 120.0f);
        c.set(SC.CDR_EFFICIENCY, 0.0f, 0.0f);
        c.setMaxLevel(4);
        return c;
    }

    @Override
    public AbilityPlace getAbilityPlace() {
        return new AbilityPlace(2, 3);
    }

    public static HuntingPotionSpell getInstance() {
        return SingletonHolder.INSTANCE;
    }

    @Override
    public String GUID() {
        return "hunting_potion";
    }

    @Override
    public List<ITextComponent> GetDescription(TooltipInfo info, SpellCastContext ctx) {
        ArrayList<ITextComponent> list = new ArrayList<ITextComponent>();
        list.add((ITextComponent)new StringTextComponent("Heal yourself instantly: "));
        list.addAll(this.getCalculation(ctx).GetTooltipString(info, ctx));
        return list;
    }

    @Override
    public Words getName() {
        return Words.HuntingPotion;
    }

    @Override
    public void castExtra(SpellCastContext ctx) {
        try {
            ParticleUtils.spawnParticles((ParticleType)ParticleTypes.field_197633_z, ctx.caster, 80);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static class SingletonHolder {
        private static final HuntingPotionSpell INSTANCE = new HuntingPotionSpell();

        private SingletonHolder() {
        }
    }
}

