/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.spells.spell_classes.hunting;

import com.robertx22.mine_and_slash.database.spells.entities.proj.RangerArrowEntity;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.BaseSpell;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.SpellCastContext;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.SpellPredicates;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.cast_types.SpellCastType;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.configs.ImmutableSpellConfigs;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.configs.PreCalcSpellConfigs;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.configs.SC;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.TooltipInfo;
import com.robertx22.mine_and_slash.saveclasses.spells.AbilityPlace;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Elements;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Masteries;
import com.robertx22.mine_and_slash.uncommon.localization.Words;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SEntityVelocityPacket;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;

public class RecoilShotSpell
extends BaseSpell {
    private RecoilShotSpell() {
        super(new ImmutableSpellConfigs(){

            @Override
            public Masteries school() {
                return Masteries.HUNTING;
            }

            @Override
            public SpellCastType castType() {
                return SpellCastType.PROJECTILE;
            }

            @Override
            public SoundEvent sound() {
                return SoundEvents.field_187737_v;
            }

            @Override
            public Elements element() {
                return Elements.Elemental;
            }
        }.cooldownIfCanceled(true).summonsEntity(w -> new RangerArrowEntity((World)w)).addCastRequirement(SpellPredicates.REQUIRE_SHOOTABLE));
    }

    @Override
    public PreCalcSpellConfigs getPreCalcConfig() {
        PreCalcSpellConfigs c = new PreCalcSpellConfigs();
        c.set(SC.MANA_COST, 4.0f, 9.0f);
        c.set(SC.BASE_VALUE, 2.0f, 3.0f);
        c.set(SC.ATTACK_SCALE_VALUE, 1.5f, 2.0f);
        c.set(SC.SHOOT_SPEED, 2.5f, 3.75f);
        c.set(SC.PROJECTILE_COUNT, 1.0f, 1.0f);
        c.set(SC.CAST_TIME_TICKS, 0.0f, 0.0f);
        c.set(SC.COOLDOWN_SECONDS, 14.0f, 10.0f);
        c.set(SC.DURATION_TICKS, 100.0f, 160.0f);
        c.setMaxLevel(8);
        return c;
    }

    @Override
    public AbilityPlace getAbilityPlace() {
        return new AbilityPlace(4, 2);
    }

    public static RecoilShotSpell getInstance() {
        return SingletonHolder.INSTANCE;
    }

    @Override
    public String GUID() {
        return "recoil_shot";
    }

    public static void dashBackward(LivingEntity caster) {
        float distance = (float)Math.PI / 180;
        caster.func_213317_d(new Vec3d(0.0, 0.0, 0.0));
        double x = -MathHelper.func_76126_a((float)(caster.field_70177_z * distance));
        double z = MathHelper.func_76134_b((float)(caster.field_70177_z * distance));
        caster.func_70653_a((Entity)caster, 1.8f, x, z);
        if (caster instanceof ServerPlayerEntity) {
            ((ServerPlayerEntity)caster).field_71135_a.func_147359_a((IPacket)new SEntityVelocityPacket((Entity)caster));
            caster.field_70133_I = false;
        }
    }

    @Override
    public void castExtra(SpellCastContext ctx) {
        RecoilShotSpell.dashBackward(ctx.caster);
    }

    @Override
    public List<ITextComponent> GetDescription(TooltipInfo info, SpellCastContext ctx) {
        ArrayList<ITextComponent> list = new ArrayList<ITextComponent>();
        list.add((ITextComponent)new StringTextComponent("Shoots an arrow and dash back: "));
        list.addAll(this.getCalculation(ctx).GetTooltipString(info, ctx));
        return list;
    }

    @Override
    public Words getName() {
        return Words.RecoilShot;
    }

    private static class SingletonHolder {
        private static final RecoilShotSpell INSTANCE = new RecoilShotSpell();

        private SingletonHolder() {
        }
    }
}

