/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.spells.spell_classes.nature;

import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.BaseSpell;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.SpellCastContext;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.cast_types.SpellCastType;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.configs.ImmutableSpellConfigs;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.configs.PreCalcSpellConfigs;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.configs.SC;
import com.robertx22.mine_and_slash.packets.particles.ParticleEnum;
import com.robertx22.mine_and_slash.packets.particles.ParticlePacketData;
import com.robertx22.mine_and_slash.potion_effects.bases.PotionEffectUtils;
import com.robertx22.mine_and_slash.potion_effects.druid.MindRotEffect;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.TooltipInfo;
import com.robertx22.mine_and_slash.saveclasses.spells.AbilityPlace;
import com.robertx22.mine_and_slash.saveclasses.spells.IAbility;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Elements;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Masteries;
import com.robertx22.mine_and_slash.uncommon.localization.Words;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.EntityFinder;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.SoundUtils;
import com.robertx22.mine_and_slash.uncommon.wrappers.SText;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class ThoughtSeizeSpell
extends BaseSpell {
    private ThoughtSeizeSpell() {
        super(new ImmutableSpellConfigs(){

            @Override
            public Masteries school() {
                return Masteries.NATURE;
            }

            @Override
            public SpellCastType castType() {
                return SpellCastType.SPECIAL;
            }

            @Override
            public SoundEvent sound() {
                return SoundEvents.field_204328_gh;
            }

            @Override
            public Elements element() {
                return Elements.Nature;
            }
        });
    }

    @Override
    public PreCalcSpellConfigs getPreCalcConfig() {
        PreCalcSpellConfigs c = new PreCalcSpellConfigs();
        c.set(SC.MANA_COST, 12.0f, 22.0f);
        c.set(SC.BASE_VALUE, 0.0f, 0.0f);
        c.set(SC.CAST_TIME_TICKS, 0.0f, 0.0f);
        c.set(SC.COOLDOWN_SECONDS, 5.0f, 2.0f);
        c.set(SC.RADIUS, 6.0f, 12.0f);
        c.set(SC.TIMES_TO_CAST, 1.0f, 1.0f);
        c.set(SC.DURATION_TICKS, 400.0f, 600.0f);
        c.set(SC.TICK_RATE, 40.0f, 40.0f);
        c.setMaxLevel(6);
        return c;
    }

    @Override
    public AbilityPlace getAbilityPlace() {
        return new AbilityPlace(7, 1);
    }

    public static ThoughtSeizeSpell getInstance() {
        return SingletonHolder.INSTANCE;
    }

    @Override
    public String GUID() {
        return "thought_seize";
    }

    @Override
    public List<ITextComponent> GetDescription(TooltipInfo info, SpellCastContext ctx) {
        ArrayList<ITextComponent> list = new ArrayList<ITextComponent>();
        list.add((ITextComponent)new SText("Curses enemies around you with mind rot: "));
        list.addAll(MindRotEffect.INSTANCE.GetTooltipStringWithNoExtraSpellInfo(info));
        list.add((ITextComponent)new StringTextComponent("Only one curse is allowed at a time!"));
        return list;
    }

    public void damageMobsAroundYou(SpellCastContext ctx, LivingEntity caster) {
        if (!caster.field_70170_p.field_72995_K) {
            float radius = ctx.getConfigFor(this).get(SC.RADIUS).get(ctx.spellsCap, (IAbility)this);
            ParticlePacketData pdata = new ParticlePacketData(caster.func_180425_c().func_177981_b(1), ParticleEnum.POISON_CLOUD);
            pdata.radius = radius;
            ParticleEnum.sendToClients((Entity)caster, pdata);
            int num = this.getCalculation(ctx).getCalculatedValue(Load.Unit((ICapabilityProvider)caster), ctx.spellsCap, ctx.ability);
            List<LivingEntity> entities = EntityFinder.start(caster, LivingEntity.class, caster.func_174791_d()).radius(radius).build();
            for (LivingEntity en : entities) {
                PotionEffectUtils.apply(MindRotEffect.INSTANCE, caster, en);
            }
        }
    }

    @Override
    public Words getName() {
        return Words.ThoughtSeize;
    }

    @Override
    public void castExtra(SpellCastContext ctx) {
        this.damageMobsAroundYou(ctx, ctx.caster);
        SoundUtils.playSound((Entity)ctx.caster, SoundEvents.field_187541_bC, 1.0f, 0.6f);
    }

    private static class SingletonHolder {
        private static final ThoughtSeizeSpell INSTANCE = new ThoughtSeizeSpell();

        private SingletonHolder() {
        }
    }
}

