/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.spells.spell_classes.ocean;

import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.BaseSpell;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.SpellCastContext;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.cast_types.SpellCastType;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.configs.ImmutableSpellConfigs;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.configs.PreCalcSpellConfigs;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.configs.SC;
import com.robertx22.mine_and_slash.mmorpg.registers.common.ModSounds;
import com.robertx22.mine_and_slash.potion_effects.bases.PotionEffectUtils;
import com.robertx22.mine_and_slash.potion_effects.ocean_mystic.FrozenEffect;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.TooltipInfo;
import com.robertx22.mine_and_slash.saveclasses.spells.AbilityPlace;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Elements;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Masteries;
import com.robertx22.mine_and_slash.uncommon.localization.Words;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.EntityFinder;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.SoundUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;

public class FreezeSpell
extends BaseSpell {
    private FreezeSpell() {
        super(new ImmutableSpellConfigs(){

            @Override
            public Masteries school() {
                return Masteries.OCEAN;
            }

            @Override
            public SpellCastType castType() {
                return SpellCastType.SPECIAL;
            }

            @Override
            public SoundEvent sound() {
                return (SoundEvent)ModSounds.FREEZE.get();
            }

            @Override
            public Elements element() {
                return Elements.Water;
            }
        }.setSwingArmOnCast());
    }

    public static FreezeSpell getInstance() {
        return SingletonHolder.INSTANCE;
    }

    @Override
    public AbilityPlace getAbilityPlace() {
        return new AbilityPlace(4, 3);
    }

    @Override
    public PreCalcSpellConfigs getPreCalcConfig() {
        PreCalcSpellConfigs c = new PreCalcSpellConfigs();
        c.set(SC.MANA_COST, 16.0f, 24.0f);
        c.set(SC.BASE_VALUE, 1.0f, 4.0f);
        c.set(SC.SHOOT_SPEED, 0.8f, 1.4f);
        c.set(SC.CAST_TIME_TICKS, 60.0f, 20.0f);
        c.set(SC.COOLDOWN_SECONDS, 38.0f, 30.0f);
        c.setMaxLevel(8);
        return c;
    }

    @Override
    public String GUID() {
        return "freeze";
    }

    @Override
    public List<ITextComponent> GetDescription(TooltipInfo info, SpellCastContext ctx) {
        ArrayList<ITextComponent> list = new ArrayList<ITextComponent>();
        list.add((ITextComponent)new StringTextComponent("Target enemies in front of you."));
        list.add((ITextComponent)new StringTextComponent("Applies: "));
        list.addAll(FrozenEffect.INSTANCE.GetTooltipStringWithNoExtraSpellInfo(info));
        return list;
    }

    @Override
    public Words getName() {
        return Words.Freeze;
    }

    @Override
    public void castExtra(SpellCastContext ctx) {
        LivingEntity caster = ctx.caster;
        World world = caster.field_70170_p;
        SoundUtils.playSound((Entity)caster, (SoundEvent)ModSounds.FREEZE.get(), 0.5f, 0.5f);
        EntityFinder.start(caster, LivingEntity.class, caster.func_174791_d()).radius(3.0).distance(8.0).finder(EntityFinder.Finder.IN_FRONT).build().forEach(x -> PotionEffectUtils.apply(FrozenEffect.INSTANCE, caster, x));
    }

    private static class SingletonHolder {
        private static final FreezeSpell INSTANCE = new FreezeSpell();

        private SingletonHolder() {
        }
    }
}

