/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.spells.spell_classes.ocean;

import com.robertx22.mine_and_slash.database.spells.SpellUtils;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.BaseSpell;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.SpellCastContext;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.cast_types.SpellCastType;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.configs.ImmutableSpellConfigs;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.configs.PreCalcSpellConfigs;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.configs.SC;
import com.robertx22.mine_and_slash.mmorpg.registers.common.ModSounds;
import com.robertx22.mine_and_slash.mmorpg.registers.common.ParticleRegister;
import com.robertx22.mine_and_slash.packets.particles.ParticleEnum;
import com.robertx22.mine_and_slash.packets.particles.ParticlePacketData;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.TooltipInfo;
import com.robertx22.mine_and_slash.saveclasses.spells.AbilityPlace;
import com.robertx22.mine_and_slash.saveclasses.spells.IAbility;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Elements;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Masteries;
import com.robertx22.mine_and_slash.uncommon.localization.Words;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.EntityFinder;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.ParticleUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.LivingEntity;
import net.minecraft.particles.ParticleType;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class HeartOfIceSpell
extends BaseSpell {
    private HeartOfIceSpell() {
        super(new ImmutableSpellConfigs(){

            @Override
            public Masteries school() {
                return Masteries.OCEAN;
            }

            @Override
            public SpellCastType castType() {
                return SpellCastType.SELF_HEAL;
            }

            @Override
            public SoundEvent sound() {
                return (SoundEvent)ModSounds.FREEZE.get();
            }

            @Override
            public Elements element() {
                return Elements.Water;
            }
        }.cooldownIfCanceled(true).setSwingArmOnCast());
    }

    @Override
    public PreCalcSpellConfigs getPreCalcConfig() {
        PreCalcSpellConfigs c = new PreCalcSpellConfigs();
        c.set(SC.MANA_COST, 12.0f, 18.0f);
        c.set(SC.BASE_VALUE, 4.0f, 14.0f);
        c.set(SC.RADIUS, 5.0f, 10.0f);
        c.set(SC.CAST_TIME_TICKS, 60.0f, 60.0f);
        c.set(SC.TIMES_TO_CAST, 3.0f, 5.0f);
        c.set(SC.COOLDOWN_SECONDS, 40.0f, 30.0f);
        c.setMaxLevel(8);
        return c;
    }

    @Override
    public AbilityPlace getAbilityPlace() {
        return new AbilityPlace(7, 4);
    }

    public static HeartOfIceSpell getInstance() {
        return SingletonHolder.INSTANCE;
    }

    @Override
    public String GUID() {
        return "heart_of_ice";
    }

    @Override
    public List<ITextComponent> GetDescription(TooltipInfo info, SpellCastContext ctx) {
        ArrayList<ITextComponent> list = new ArrayList<ITextComponent>();
        list.add((ITextComponent)new StringTextComponent("Heal allies around you: "));
        list.addAll(this.getCalculation(ctx).GetTooltipString(info, ctx));
        return list;
    }

    @Override
    public Words getName() {
        return Words.HeartOfIce;
    }

    @Override
    public void castExtra(SpellCastContext ctx) {
        try {
            ParticleUtils.spawnParticles((ParticleType)ParticleRegister.BUBBLE, ctx.caster, 80);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        float RADIUS = ctx.getConfigFor(this).get(SC.RADIUS).get(ctx.spellsCap, (IAbility)this);
        List<LivingEntity> list = EntityFinder.start(ctx.caster, LivingEntity.class, ctx.caster.func_174791_d()).finder(EntityFinder.Finder.RADIUS).radius(RADIUS).searchFor(EntityFinder.SearchFor.ALLIES).build();
        for (LivingEntity en : list) {
            int num = ctx.getConfigFor(this).getCalc(ctx.spellsCap, this).getCalculatedValue(ctx.data, ctx.spellsCap, this);
            SpellUtils.heal(this, en, num);
            ParticleEnum.sendToClients(en.func_180425_c(), en.field_70170_p, new ParticlePacketData(en.func_174791_d(), ParticleEnum.AOE).radius(RADIUS).motion(new Vec3d(0.0, 0.0, 0.0)).type((ParticleType)ParticleTypes.field_197593_D).amount(90));
            ParticleEnum.sendToClients(en.func_180425_c(), en.field_70170_p, new ParticlePacketData(en.func_174791_d(), ParticleEnum.AOE).radius(RADIUS).motion(new Vec3d(0.0, 0.0, 0.0)).type((ParticleType)ParticleTypes.field_197633_z).amount(45));
        }
    }

    private static class SingletonHolder {
        private static final HeartOfIceSpell INSTANCE = new HeartOfIceSpell();

        private SingletonHolder() {
        }
    }
}

