/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.spells.spell_classes.ocean;

import com.robertx22.mine_and_slash.database.spells.entities.proj.WhirlpoolEntity;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.BaseSpell;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.SpellCastContext;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.cast_types.SpellCastType;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.configs.ImmutableSpellConfigs;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.configs.PreCalcSpellConfigs;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.configs.SC;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.TooltipInfo;
import com.robertx22.mine_and_slash.saveclasses.spells.AbilityPlace;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Elements;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Masteries;
import com.robertx22.mine_and_slash.uncommon.localization.Words;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;

public class WhirlpoolSpell
extends BaseSpell {
    private WhirlpoolSpell() {
        super(new ImmutableSpellConfigs(){

            @Override
            public Masteries school() {
                return Masteries.OCEAN;
            }

            @Override
            public SpellCastType castType() {
                return SpellCastType.PROJECTILE;
            }

            @Override
            public SoundEvent sound() {
                return SoundEvents.field_203252_T;
            }

            @Override
            public Elements element() {
                return Elements.Elemental;
            }
        }.summonsEntity(w -> new WhirlpoolEntity((World)w)).setSwingArmOnCast());
    }

    @Override
    public PreCalcSpellConfigs getPreCalcConfig() {
        PreCalcSpellConfigs c = new PreCalcSpellConfigs();
        c.set(SC.MANA_COST, 16.0f, 30.0f);
        c.set(SC.BASE_VALUE, 6.0f, 12.0f);
        c.set(SC.SHOOT_SPEED, 0.8f, 1.2f);
        c.set(SC.PROJECTILE_COUNT, 1.0f, 1.0f);
        c.set(SC.CAST_TIME_TICKS, 50.0f, 40.0f);
        c.set(SC.COOLDOWN_SECONDS, 18.0f, 14.0f);
        c.set(SC.TICK_RATE, 30.0f, 20.0f);
        c.set(SC.RADIUS, 4.0f, 6.0f);
        c.set(SC.DURATION_TICKS, 80.0f, 100.0f);
        c.setMaxLevel(12);
        return c;
    }

    @Override
    public AbilityPlace getAbilityPlace() {
        return new AbilityPlace(1, 3);
    }

    public static WhirlpoolSpell getInstance() {
        return SingletonHolder.INSTANCE;
    }

    @Override
    public String GUID() {
        return "whirlpool";
    }

    @Override
    public List<ITextComponent> GetDescription(TooltipInfo info, SpellCastContext ctx) {
        ArrayList<ITextComponent> list = new ArrayList<ITextComponent>();
        list.add((ITextComponent)new StringTextComponent("Summons a whirlpool that slows and damages enemies: "));
        list.addAll(this.getCalculation(ctx).GetTooltipString(info, ctx));
        return list;
    }

    @Override
    public Words getName() {
        return Words.Whirpool;
    }

    private static class SingletonHolder {
        private static final WhirlpoolSpell INSTANCE = new WhirlpoolSpell();

        private SingletonHolder() {
        }
    }
}

