/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.spells.spell_classes.storm;

import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.BaseSpell;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.SpellCastContext;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.cast_types.SpellCastType;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.configs.ImmutableSpellConfigs;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.configs.PreCalcSpellConfigs;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.configs.SC;
import com.robertx22.mine_and_slash.packets.particles.ParticleEnum;
import com.robertx22.mine_and_slash.packets.particles.ParticlePacketData;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.TooltipInfo;
import com.robertx22.mine_and_slash.saveclasses.spells.AbilityPlace;
import com.robertx22.mine_and_slash.saveclasses.spells.IAbility;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.effectdatas.DamageEffect;
import com.robertx22.mine_and_slash.uncommon.effectdatas.EffectData;
import com.robertx22.mine_and_slash.uncommon.effectdatas.interfaces.WeaponTypes;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Elements;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Masteries;
import com.robertx22.mine_and_slash.uncommon.localization.Words;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.EntityFinder;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.SoundUtils;
import com.robertx22.mine_and_slash.uncommon.wrappers.SText;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class ChargedNovaSpell
extends BaseSpell {
    private ChargedNovaSpell() {
        super(new ImmutableSpellConfigs(){

            @Override
            public Masteries school() {
                return Masteries.STORM;
            }

            @Override
            public SpellCastType castType() {
                return SpellCastType.SPECIAL;
            }

            @Override
            public SoundEvent sound() {
                return SoundEvents.field_187754_de;
            }

            @Override
            public Elements element() {
                return Elements.Thunder;
            }
        }.cooldownIfCanceled(true));
    }

    @Override
    public PreCalcSpellConfigs getPreCalcConfig() {
        PreCalcSpellConfigs c = new PreCalcSpellConfigs();
        c.set(SC.MANA_COST, 22.0f, 36.0f);
        c.set(SC.BASE_VALUE, 6.0f, 11.0f);
        c.set(SC.CAST_TIME_TICKS, 80.0f, 60.0f);
        c.set(SC.COOLDOWN_SECONDS, 18.0f, 14.0f);
        c.set(SC.RADIUS, 2.0f, 4.0f);
        c.set(SC.TIMES_TO_CAST, 3.0f, 5.0f);
        c.setMaxLevel(12);
        return c;
    }

    @Override
    public AbilityPlace getAbilityPlace() {
        return new AbilityPlace(7, 1);
    }

    public static ChargedNovaSpell getInstance() {
        return SingletonHolder.INSTANCE;
    }

    @Override
    public String GUID() {
        return "charged_nova";
    }

    @Override
    public List<ITextComponent> GetDescription(TooltipInfo info, SpellCastContext ctx) {
        ArrayList<ITextComponent> list = new ArrayList<ITextComponent>();
        list.add((ITextComponent)new SText("Do damage to enemies around you: "));
        list.addAll(this.getCalculation(ctx).GetTooltipString(info, ctx));
        return list;
    }

    public void damageMobsAroundYou(SpellCastContext ctx, LivingEntity caster) {
        if (!caster.field_70170_p.field_72995_K) {
            float radius = ctx.getConfigFor(this).get(SC.RADIUS).get(ctx.spellsCap, (IAbility)this);
            ParticlePacketData pdata = new ParticlePacketData(caster.func_180425_c().func_177981_b(1), ParticleEnum.CHARGED_NOVA);
            pdata.radius = radius;
            ParticleEnum.sendToClients((Entity)caster, pdata);
            int num = this.getCalculation(ctx).getCalculatedValue(Load.Unit((ICapabilityProvider)caster), ctx.spellsCap, ctx.ability);
            List<LivingEntity> entities = EntityFinder.start(caster, LivingEntity.class, caster.func_174791_d()).radius(radius).build();
            for (LivingEntity en : entities) {
                DamageEffect dmg = new DamageEffect(null, caster, en, num, EffectData.EffectTypes.SPELL, WeaponTypes.None);
                dmg.element = Elements.Thunder;
                dmg.Activate();
            }
        }
    }

    @Override
    public Words getName() {
        return Words.ChargedNova;
    }

    @Override
    public void castExtra(SpellCastContext ctx) {
        this.damageMobsAroundYou(ctx, ctx.caster);
        SoundUtils.playSound((Entity)ctx.caster, SoundEvents.field_187752_dd, 1.0f, 1.0f);
    }

    private static class SingletonHolder {
        private static final ChargedNovaSpell INSTANCE = new ChargedNovaSpell();

        private SingletonHolder() {
        }
    }
}

