/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.spells.spell_classes.storm;

import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.BaseSpell;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.SpellCastContext;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.cast_types.SpellCastType;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.configs.ImmutableSpellConfigs;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.configs.PreCalcSpellConfigs;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.configs.SC;
import com.robertx22.mine_and_slash.potion_effects.shaman.PowerSurgeEffect;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.TooltipInfo;
import com.robertx22.mine_and_slash.saveclasses.spells.AbilityPlace;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Elements;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Masteries;
import com.robertx22.mine_and_slash.uncommon.localization.Words;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.ParticleUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.particles.ParticleType;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class PowerSurgeSpell
extends BaseSpell {
    private PowerSurgeSpell() {
        super(new ImmutableSpellConfigs(){

            @Override
            public Masteries school() {
                return Masteries.STORM;
            }

            @Override
            public SpellCastType castType() {
                return SpellCastType.GIVE_EFFECT;
            }

            @Override
            public SoundEvent sound() {
                return SoundEvents.field_187754_de;
            }

            @Override
            public Elements element() {
                return Elements.Thunder;
            }
        }.addsEffect(PowerSurgeEffect.INSTANCE).setSwingArmOnCast());
    }

    @Override
    public PreCalcSpellConfigs getPreCalcConfig() {
        PreCalcSpellConfigs c = new PreCalcSpellConfigs();
        c.set(SC.MANA_COST, 32.0f, 42.0f);
        c.set(SC.CAST_TIME_TICKS, 120.0f, 80.0f);
        c.set(SC.COOLDOWN_SECONDS, 40.0f, 30.0f);
        c.set(SC.DURATION_TICKS, 2400.0f, 3600.0f);
        c.setMaxLevel(6);
        return c;
    }

    public static PowerSurgeSpell getInstance() {
        return SingletonHolder.INSTANCE;
    }

    @Override
    public String GUID() {
        return "power_surge";
    }

    @Override
    public List<ITextComponent> GetDescription(TooltipInfo info, SpellCastContext ctx) {
        ArrayList<ITextComponent> list = new ArrayList<ITextComponent>();
        list.add((ITextComponent)new StringTextComponent("Applies buff: "));
        list.addAll(PowerSurgeEffect.INSTANCE.GetTooltipStringWithNoExtraSpellInfo(info));
        list.add((ITextComponent)new StringTextComponent("Only one Storm surge is allowed at a time!"));
        return list;
    }

    @Override
    public Words getName() {
        return Words.PowerSurge;
    }

    @Override
    public void spawnParticles(SpellCastContext ctx) {
        if (ctx.caster.field_70170_p.field_72995_K) {
            ParticleUtils.spawnParticles((ParticleType)ParticleTypes.field_197632_y, ctx.caster, 30);
        }
    }

    @Override
    public AbilityPlace getAbilityPlace() {
        return new AbilityPlace(5, 1);
    }

    private static class SingletonHolder {
        private static final PowerSurgeSpell INSTANCE = new PowerSurgeSpell();

        private SingletonHolder() {
        }
    }
}

