/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.spells.spell_classes.storm;

import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.BaseSpell;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.SpellCastContext;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.cast_types.SpellCastType;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.configs.ImmutableSpellConfigs;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.configs.PreCalcSpellConfigs;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.configs.SC;
import com.robertx22.mine_and_slash.potion_effects.shaman.QuickChargeEffect;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.TooltipInfo;
import com.robertx22.mine_and_slash.saveclasses.spells.AbilityPlace;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Elements;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Masteries;
import com.robertx22.mine_and_slash.uncommon.localization.Words;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class QuickChargeSpell
extends BaseSpell {
    private QuickChargeSpell() {
        super(new ImmutableSpellConfigs(){

            @Override
            public Masteries school() {
                return Masteries.STORM;
            }

            @Override
            public SpellCastType castType() {
                return SpellCastType.AOE_EFFECT;
            }

            @Override
            public SoundEvent sound() {
                return SoundEvents.field_187604_bf;
            }

            @Override
            public Elements element() {
                return Elements.Thunder;
            }
        }.addsEffect(QuickChargeEffect.INSTANCE));
    }

    @Override
    public PreCalcSpellConfigs getPreCalcConfig() {
        PreCalcSpellConfigs c = new PreCalcSpellConfigs();
        c.set(SC.MANA_COST, 14.0f, 18.0f);
        c.set(SC.CAST_TIME_TICKS, 60.0f, 180.0f);
        c.set(SC.COOLDOWN_SECONDS, 40.0f, 30.0f);
        c.set(SC.DURATION_TICKS, 3600.0f, 7200.0f);
        c.set(SC.RADIUS, 3.0f, 6.0f);
        c.setMaxLevel(8);
        return c;
    }

    @Override
    public AbilityPlace getAbilityPlace() {
        return new AbilityPlace(6, 3);
    }

    public static QuickChargeSpell getInstance() {
        return SingletonHolder.INSTANCE;
    }

    @Override
    public String GUID() {
        return "quick_charge";
    }

    @Override
    public List<ITextComponent> GetDescription(TooltipInfo info, SpellCastContext ctx) {
        ArrayList<ITextComponent> list = new ArrayList<ITextComponent>();
        list.add((ITextComponent)new StringTextComponent("Applies buff to all nearby allies: "));
        list.addAll(QuickChargeEffect.INSTANCE.GetTooltipStringWithNoExtraSpellInfo(info));
        return list;
    }

    @Override
    public Words getName() {
        return Words.QuickCharge;
    }

    private static class SingletonHolder {
        private static final QuickChargeSpell INSTANCE = new QuickChargeSpell();

        private SingletonHolder() {
        }
    }
}

