/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.spells.spell_classes.storm;

import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.BaseSpell;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.SpellCastContext;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.cast_types.SpellCastType;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.configs.ImmutableSpellConfigs;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.configs.PreCalcSpellConfigs;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.configs.SC;
import com.robertx22.mine_and_slash.mmorpg.registers.common.ModSounds;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.TooltipInfo;
import com.robertx22.mine_and_slash.saveclasses.spells.AbilityPlace;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.effectdatas.DamageEffect;
import com.robertx22.mine_and_slash.uncommon.effectdatas.EffectData;
import com.robertx22.mine_and_slash.uncommon.effectdatas.interfaces.WeaponTypes;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Elements;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Masteries;
import com.robertx22.mine_and_slash.uncommon.localization.Words;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.EntityFinder;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.SoundUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SEntityVelocityPacket;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class ThunderDashSpell
extends BaseSpell {
    private ThunderDashSpell() {
        super(new ImmutableSpellConfigs(){

            @Override
            public Masteries school() {
                return Masteries.STORM;
            }

            @Override
            public SpellCastType castType() {
                return SpellCastType.SPECIAL;
            }

            @Override
            public SoundEvent sound() {
                return SoundEvents.field_187754_de;
            }

            @Override
            public Elements element() {
                return Elements.Thunder;
            }
        });
    }

    @Override
    public PreCalcSpellConfigs getPreCalcConfig() {
        PreCalcSpellConfigs c = new PreCalcSpellConfigs();
        c.set(SC.MANA_COST, 40.0f, 20.0f);
        c.set(SC.BASE_VALUE, 3.0f, 6.0f);
        c.set(SC.CAST_TIME_TICKS, 0.0f, 0.0f);
        c.set(SC.COOLDOWN_SECONDS, 7.0f, 7.0f);
        c.setMaxLevel(8);
        return c;
    }

    @Override
    public AbilityPlace getAbilityPlace() {
        return new AbilityPlace(4, 3);
    }

    public static ThunderDashSpell getInstance() {
        return SingletonHolder.INSTANCE;
    }

    @Override
    public String GUID() {
        return "thunder_dash";
    }

    @Override
    public List<ITextComponent> GetDescription(TooltipInfo info, SpellCastContext ctx) {
        ArrayList<ITextComponent> list = new ArrayList<ITextComponent>();
        list.add((ITextComponent)new StringTextComponent("Dash in your current direction,"));
        list.add((ITextComponent)new StringTextComponent("damages all enemies in the path: "));
        list.addAll(this.getCalculation(ctx).GetTooltipString(info, ctx));
        return list;
    }

    @Override
    public Words getName() {
        return Words.ThunderDash;
    }

    public static void dashForward(LivingEntity caster) {
        float distance = (float)Math.PI / 180;
        caster.func_213317_d(new Vec3d(0.0, 0.0, 0.0));
        caster.func_70653_a((Entity)caster, 3.5f, (double)MathHelper.func_76126_a((float)(caster.field_70177_z * distance)), (double)(-MathHelper.func_76134_b((float)(caster.field_70177_z * distance))));
        if (caster instanceof ServerPlayerEntity) {
            ((ServerPlayerEntity)caster).field_71135_a.func_147359_a((IPacket)new SEntityVelocityPacket((Entity)caster));
            caster.field_70133_I = false;
        }
    }

    @Override
    public void castExtra(SpellCastContext ctx) {
        LivingEntity caster = ctx.caster;
        World world = ctx.caster.field_70170_p;
        ThunderDashSpell.dashForward(ctx.caster);
        int num = this.getCalculation(ctx).getCalculatedValue(Load.Unit((ICapabilityProvider)caster), ctx.spellsCap, ctx.ability);
        List<LivingEntity> entities = EntityFinder.start(caster, LivingEntity.class, caster.func_174791_d()).radius(2.0).distance(10.0).finder(EntityFinder.Finder.IN_FRONT).build();
        entities.forEach(x -> {
            DamageEffect dmg = new DamageEffect(null, caster, (LivingEntity)x, num, EffectData.EffectTypes.SPELL, WeaponTypes.None);
            dmg.element = Elements.Thunder;
            dmg.Activate();
        });
        SoundUtils.playSound((Entity)caster, (SoundEvent)ModSounds.DASH.get(), 1.0f, 1.0f);
    }

    private static class SingletonHolder {
        private static final ThunderDashSpell INSTANCE = new ThunderDashSpell();

        private SingletonHolder() {
        }
    }
}

