/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.spells.spell_classes.storm;

import com.robertx22.mine_and_slash.database.spells.entities.trident.ThunderspearEntity;
import com.robertx22.mine_and_slash.database.spells.spell_classes.SpellTooltips;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.BaseSpell;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.SpellCastContext;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.cast_types.SpellCastType;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.configs.ImmutableSpellConfigs;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.configs.PreCalcSpellConfigs;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.configs.SC;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.TooltipInfo;
import com.robertx22.mine_and_slash.saveclasses.spells.AbilityPlace;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Elements;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Masteries;
import com.robertx22.mine_and_slash.uncommon.localization.Words;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;

public class ThunderspearSpell
extends BaseSpell {
    private ThunderspearSpell() {
        super(new ImmutableSpellConfigs(){

            @Override
            public Masteries school() {
                return Masteries.STORM;
            }

            @Override
            public SpellCastType castType() {
                return SpellCastType.PROJECTILE;
            }

            @Override
            public SoundEvent sound() {
                return SoundEvents.field_203274_ip;
            }

            @Override
            public Elements element() {
                return Elements.Thunder;
            }
        }.rightClickFor(BaseSpell.AllowedAsRightClickOn.MAGE_WEAPON).summonsEntity(world -> new ThunderspearEntity((World)world)));
    }

    @Override
    public PreCalcSpellConfigs getPreCalcConfig() {
        PreCalcSpellConfigs c = new PreCalcSpellConfigs();
        c.set(SC.MANA_COST, 7.0f, 15.0f);
        c.set(SC.BASE_VALUE, 10.0f, 15.0f);
        c.set(SC.SHOOT_SPEED, 2.2f, 2.75f);
        c.set(SC.PROJECTILE_COUNT, 1.0f, 1.0f);
        c.set(SC.CAST_TIME_TICKS, 0.0f, 0.0f);
        c.set(SC.COOLDOWN_TICKS, 60.0f, 60.0f);
        c.set(SC.DURATION_TICKS, 40.0f, 60.0f);
        c.setMaxLevel(16);
        return c;
    }

    @Override
    public AbilityPlace getAbilityPlace() {
        return new AbilityPlace(0, 0);
    }

    public static ThunderspearSpell getInstance() {
        return SingletonHolder.INSTANCE;
    }

    @Override
    public String GUID() {
        return "thunder_spear";
    }

    @Override
    public List<ITextComponent> GetDescription(TooltipInfo info, SpellCastContext ctx) {
        ArrayList<ITextComponent> list = new ArrayList<ITextComponent>();
        list.add(SpellTooltips.singleTargetProjectile());
        list.addAll(this.getCalculation(ctx).GetTooltipString(info, ctx));
        return list;
    }

    @Override
    public Words getName() {
        return Words.ThunderSpear;
    }

    private static class SingletonHolder {
        private static final ThunderspearSpell INSTANCE = new ThunderspearSpell();

        private SingletonHolder() {
        }
    }
}

