/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.spells.synergies.base;

import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.BaseSpell;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.SpellCastContext;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.configs.PreCalcSpellConfigs;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.configs.SC;
import com.robertx22.mine_and_slash.registry.ISlashRegistryEntry;
import com.robertx22.mine_and_slash.registry.SlashRegistryType;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.TooltipInfo;
import com.robertx22.mine_and_slash.saveclasses.spells.AbilityPlace;
import com.robertx22.mine_and_slash.saveclasses.spells.IAbility;
import com.robertx22.mine_and_slash.saveclasses.spells.calc.SpellCalcData;
import com.robertx22.mine_and_slash.uncommon.capability.player.PlayerSpellCap;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.effectdatas.SpellDamageEffect;
import com.robertx22.mine_and_slash.uncommon.effectdatas.SynergyDamageEffect;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Elements;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Masteries;
import com.robertx22.mine_and_slash.uncommon.interfaces.IAutoLocName;
import com.robertx22.mine_and_slash.uncommon.interfaces.IBaseAutoLoc;
import com.robertx22.mine_and_slash.uncommon.wrappers.SText;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public abstract class Synergy
implements IAbility,
ISlashRegistryEntry<Synergy>,
IAutoLocName {
    public float get(LivingEntity en, SC sc) {
        return this.getContext(en).getConfigFor(this).get(sc).get(Load.spells(en), (IAbility)this);
    }

    public abstract List<ITextComponent> getSynergyTooltipInternal(TooltipInfo var1);

    @Override
    public ITextComponent getLocName() {
        return this.locName();
    }

    @Override
    public IBaseAutoLoc.AutoLocGroup locNameGroup() {
        return IBaseAutoLoc.AutoLocGroup.Spells;
    }

    @Override
    public String locNameLangFileGUID() {
        return "mmorpg.synergy." + this.GUID();
    }

    @Override
    public final String GUID() {
        return this.getSpell().GUID() + "_syn_" + this.getSynergyPlace().number;
    }

    @Override
    public final AbilityPlace getAbilityPlace() {
        return new AbilityPlace(this.getSpell().getAbilityPlace().x, this.getSpell().getAbilityPlace().y + this.getSynergyPlace().number);
    }

    public abstract Place getSynergyPlace();

    @Override
    public List<ITextComponent> GetTooltipString(TooltipInfo info) {
        ArrayList<ITextComponent> list = new ArrayList<ITextComponent>();
        SpellCastContext ctx = new SpellCastContext((LivingEntity)info.player, 0, this);
        list.addAll(this.getSynergyTooltipInternal(info));
        list.add((ITextComponent)new SText(""));
        this.finishTooltip(list, ctx, info);
        return list;
    }

    public int getCalcVal(LivingEntity en) {
        return this.getCalc(Load.spells(en)).getCalculatedValue(Load.Unit((ICapabilityProvider)en), Load.spells(en), this);
    }

    public SynergyDamageEffect getSynergyDamage(SpellDamageEffect ctx, int num) {
        SynergyDamageEffect dmg = new SynergyDamageEffect(this, ctx.source, ctx.target, num, ctx.sourceData, ctx.targetData, ctx.getSpell());
        dmg.element = ctx.getSpell().getElement();
        return dmg;
    }

    public SynergyDamageEffect getSynergyDamage(SpellDamageEffect ctx, LivingEntity target, int num) {
        SynergyDamageEffect dmg = new SynergyDamageEffect(this, ctx.source, target, num, ctx.sourceData, Load.Unit((ICapabilityProvider)target), ctx.getSpell());
        dmg.element = ctx.getSpell().getElement();
        return dmg;
    }

    public SpellCastContext getContext(LivingEntity en) {
        return new SpellCastContext(en, 0, this);
    }

    public SpellCalcData getCalc(PlayerSpellCap.ISpellsCap cap) {
        return this.getPreCalcConfig().getCalc(cap, this);
    }

    @Override
    public final IAbility.Type getAbilityType() {
        return IAbility.Type.SYNERGY;
    }

    @Override
    public Elements getElement() {
        return this.getSpell().getElement();
    }

    @Override
    public final ResourceLocation getIconLoc() {
        return new ResourceLocation("mmorpg", "textures/gui/spells/synergies/" + this.GUID() + ".png");
    }

    @Override
    public BaseSpell getSpell() {
        return (BaseSpell)this.getRequiredAbility();
    }

    public abstract void alterSpell(PreCalcSpellConfigs var1);

    public final PreCalcSpellConfigs getConfigsAffectingSpell() {
        PreCalcSpellConfigs c = PreCalcSpellConfigs.getEmptyForSynergies();
        this.alterSpell(c);
        return c;
    }

    @Override
    public final SlashRegistryType getSlashRegistryType() {
        return SlashRegistryType.SPELL_SYNERGY;
    }

    @Override
    public int getMaxSpellLevelNormal() {
        return 8;
    }

    @Override
    public int getMaxSpellLevelBuffed() {
        return this.getMaxSpellLevelNormal() + 5;
    }

    public boolean has(PlayerSpellCap.ISpellsCap spells) {
        return spells.hasSynergy(this);
    }

    @Override
    public final Masteries getMastery() {
        return this.getRequiredAbility().getMastery();
    }

    public void addSpellName(List<ITextComponent> tooltip) {
        tooltip.add(new SText(this.getSpell().getElement().format + "").func_150257_a(this.getLocName()));
    }

    public static enum Place {
        FIRST(1),
        SECOND(2),
        THIRD(3),
        FOURTH(4);

        public int number;

        private Place(int number) {
            this.number = number;
        }
    }
}

