/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.spells.synergies.fire;

import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.configs.PreCalcSpellConfigs;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.configs.SC;
import com.robertx22.mine_and_slash.database.spells.spell_classes.fire.VolcanoSpell;
import com.robertx22.mine_and_slash.database.spells.synergies.base.OnDamageDoneSynergy;
import com.robertx22.mine_and_slash.database.spells.synergies.base.Synergy;
import com.robertx22.mine_and_slash.potion_effects.bases.PotionEffectUtils;
import com.robertx22.mine_and_slash.potion_effects.ember_mage.BurnEffect;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.TooltipInfo;
import com.robertx22.mine_and_slash.saveclasses.spells.IAbility;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.effectdatas.SpellDamageEffect;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.RandomUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class VolcanoBurnSynergy
extends OnDamageDoneSynergy {
    @Override
    public List<ITextComponent> getSynergyTooltipInternal(TooltipInfo info) {
        ArrayList<ITextComponent> list = new ArrayList<ITextComponent>();
        this.addSpellName(list);
        list.add((ITextComponent)new StringTextComponent("Hits have a chance to apply: " + BurnEffect.INSTANCE.locNameForLangFile()));
        return list;
    }

    @Override
    public void alterSpell(PreCalcSpellConfigs c) {
        c.set(SC.MANA_COST, 1.0f, 2.0f);
    }

    @Override
    public PreCalcSpellConfigs getPreCalcConfig() {
        PreCalcSpellConfigs c = new PreCalcSpellConfigs();
        c.set(SC.CHANCE, 10.0f, 25.0f);
        c.setMaxLevel(6);
        return c;
    }

    @Override
    public Synergy.Place getSynergyPlace() {
        return Synergy.Place.FIRST;
    }

    @Override
    @Nullable
    public IAbility getRequiredAbility() {
        return VolcanoSpell.getInstance();
    }

    @Override
    public void tryActivate(SpellDamageEffect effect) {
        float chance = this.getContext(effect.source).getConfigFor(this).get(SC.CHANCE).get(Load.spells(effect.source), (IAbility)this);
        if (RandomUtils.roll(chance)) {
            PotionEffectUtils.apply(BurnEffect.INSTANCE, effect.source, effect.target);
        }
    }

    @Override
    public String locNameForLangFile() {
        return "Volcano Burn";
    }
}

