/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.spells.synergies.nature;

import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.BaseSpell;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.SpellCastContext;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.configs.PreCalcSpellConfigs;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.configs.SC;
import com.robertx22.mine_and_slash.database.spells.spell_classes.nature.NatureBalmSpell;
import com.robertx22.mine_and_slash.database.spells.synergies.base.OnSpellCastSynergy;
import com.robertx22.mine_and_slash.database.spells.synergies.base.Synergy;
import com.robertx22.mine_and_slash.packets.particles.ParticleEnum;
import com.robertx22.mine_and_slash.packets.particles.ParticlePacketData;
import com.robertx22.mine_and_slash.potion_effects.bases.PotionEffectUtils;
import com.robertx22.mine_and_slash.potion_effects.druid.RegenerateEffect;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.TooltipInfo;
import com.robertx22.mine_and_slash.saveclasses.spells.IAbility;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.EntityFinder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.LivingEntity;
import net.minecraft.particles.ParticleType;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class RegenerateAoeSynergy
extends OnSpellCastSynergy {
    @Override
    public List<ITextComponent> getSynergyTooltipInternal(TooltipInfo info) {
        ArrayList<ITextComponent> list = new ArrayList<ITextComponent>();
        this.addSpellName(list);
        list.add((ITextComponent)new StringTextComponent("Buff is applied in AOE around the caster."));
        return list;
    }

    @Override
    public Synergy.Place getSynergyPlace() {
        return Synergy.Place.SECOND;
    }

    @Override
    public BaseSpell getRequiredAbility() {
        return NatureBalmSpell.getInstance();
    }

    @Override
    public void alterSpell(PreCalcSpellConfigs c) {
        c.set(SC.MANA_COST, 2.0f, 3.0f);
    }

    @Override
    public PreCalcSpellConfigs getPreCalcConfig() {
        PreCalcSpellConfigs c = new PreCalcSpellConfigs();
        c.set(SC.RADIUS, 3.0f, 5.0f);
        c.setMaxLevel(3);
        return c;
    }

    @Override
    public void tryActivate(SpellCastContext ctx) {
        float radius = this.getPreCalcConfig().get(SC.RADIUS).get(ctx.spellsCap, (IAbility)this);
        BlockPos pos = ctx.caster.func_180425_c();
        ParticleEnum.sendToClients(pos, ctx.caster.field_70170_p, new ParticlePacketData(pos, ParticleEnum.NOVA).radius(radius).motion(new Vec3d(0.0, 0.0, 0.0)).type((ParticleType)ParticleTypes.field_197632_y).amount(50));
        EntityFinder.start(ctx.caster, LivingEntity.class, ctx.caster.func_174791_d()).radius(radius).searchFor(EntityFinder.SearchFor.ALLIES).build().forEach(x -> PotionEffectUtils.apply(RegenerateEffect.INSTANCE, ctx.caster, x));
    }

    @Override
    public String locNameForLangFile() {
        return "Spread Balm";
    }
}

