/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.spells.synergies.nature;

import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.configs.PreCalcSpellConfigs;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.configs.SC;
import com.robertx22.mine_and_slash.database.spells.spell_classes.nature.ThornArmorSpell;
import com.robertx22.mine_and_slash.database.spells.synergies.base.OnBasicAttackSynergy;
import com.robertx22.mine_and_slash.database.spells.synergies.base.Synergy;
import com.robertx22.mine_and_slash.potion_effects.bases.PotionEffectUtils;
import com.robertx22.mine_and_slash.potion_effects.druid.ThornArmorEffect;
import com.robertx22.mine_and_slash.potion_effects.druid.ThornsEffect;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.TooltipInfo;
import com.robertx22.mine_and_slash.saveclasses.spells.IAbility;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.effectdatas.DamageEffect;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.RandomUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class ThornArmorThornsSynergy
extends OnBasicAttackSynergy {
    @Override
    public List<ITextComponent> getSynergyTooltipInternal(TooltipInfo info) {
        ArrayList<ITextComponent> list = new ArrayList<ITextComponent>();
        this.addSpellName(list);
        list.add((ITextComponent)new StringTextComponent("Hits have a chance"));
        list.add((ITextComponent)new StringTextComponent("of applying effect: "));
        list.addAll(ThornsEffect.INSTANCE.GetTooltipStringWithNoExtraSpellInfo(info));
        return list;
    }

    @Override
    public void tryActivate(DamageEffect ctx) {
        float chance = this.getContext(ctx.source).getConfigFor(this).get(SC.CHANCE).get(Load.spells(ctx.source), (IAbility)this);
        if (RandomUtils.roll(chance) && PotionEffectUtils.has(ctx.source, ThornArmorEffect.INSTANCE)) {
            PotionEffectUtils.apply(ThornsEffect.INSTANCE, ctx.source, ctx.target);
        }
    }

    @Override
    public void alterSpell(PreCalcSpellConfigs c) {
        c.set(SC.MANA_COST, 2.0f, 3.0f);
    }

    @Override
    public PreCalcSpellConfigs getPreCalcConfig() {
        PreCalcSpellConfigs c = new PreCalcSpellConfigs();
        c.set(SC.CHANCE, 10.0f, 20.0f);
        c.setMaxLevel(6);
        return c;
    }

    @Override
    public Synergy.Place getSynergyPlace() {
        return Synergy.Place.FIRST;
    }

    @Override
    @Nullable
    public IAbility getRequiredAbility() {
        return ThornArmorSpell.getInstance();
    }

    @Override
    public String locNameForLangFile() {
        return "Thorny Armor";
    }
}

