/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.stats;

import com.google.common.base.Preconditions;
import com.google.gson.JsonObject;
import com.robertx22.mine_and_slash.data_generation.statmods.SerializableStatMod;
import com.robertx22.mine_and_slash.database.IGUID;
import com.robertx22.mine_and_slash.database.stats.Stat;
import com.robertx22.mine_and_slash.db_lists.Rarities;
import com.robertx22.mine_and_slash.onevent.data_gen.ISerializable;
import com.robertx22.mine_and_slash.onevent.data_gen.ISerializedRegistryEntry;
import com.robertx22.mine_and_slash.registry.SlashRegistryType;
import com.robertx22.mine_and_slash.registry.empty_entries.EmptyStatMod;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.ITooltipList;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.Rarity;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.TooltipInfo;
import com.robertx22.mine_and_slash.uncommon.enumclasses.StatModTypes;
import com.robertx22.mine_and_slash.uncommon.interfaces.IWeighted;
import com.robertx22.mine_and_slash.uncommon.interfaces.data_items.IRarity;
import com.robertx22.mine_and_slash.uncommon.wrappers.SText;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public abstract class StatMod
implements IWeighted,
IRarity,
IGUID,
ISerializedRegistryEntry<StatMod>,
ISerializable<StatMod>,
ITooltipList {
    public static EmptyStatMod EMPTY = EmptyStatMod.getInstance();
    public Size size = Size.NORMAL;

    public static List<StatMod> ofSize(List<StatMod> mod, Size size) {
        return mod.stream().map(x -> x.size(size)).collect(Collectors.toList());
    }

    @Override
    public List<ITextComponent> GetTooltipString(TooltipInfo info) {
        ArrayList<ITextComponent> list = new ArrayList<ITextComponent>();
        list.add(new SText(TextFormatting.GREEN + "").func_150257_a(this.GetBaseStat().locName()).func_150258_a(": " + this.getMin() + " / " + this.getMax()));
        return list;
    }

    public StatMod size(Size size) {
        String newGUID = this.getGUIDFor(this.GetBaseStat(), size, this.getModType());
        return new SerializableStatMod(this.GetBaseStat().GUID(), this.Min(), this.Max(), this.getModType(), newGUID, size, this.minSecond(), this.maxSecond());
    }

    public String getGUIDFor(Stat stat, Size size, StatModTypes type) {
        Preconditions.checkNotNull((Object)stat, (Object)this);
        Preconditions.checkNotNull((Object)((Object)size), (Object)this);
        Preconditions.checkNotNull((Object)((Object)type), (Object)this);
        return size.prefix + stat.GUID() + "_" + type.id;
    }

    @Override
    public String GUID() {
        return this.getGUIDFor(this.GetBaseStat(), this.size, this.getModType());
    }

    public List<StatMod> getAllSizeVariations() {
        ArrayList<StatMod> list = new ArrayList<StatMod>();
        Arrays.stream(Size.values()).forEach(x -> list.add(this.size((Size)((Object)x))));
        return list;
    }

    @Override
    public SlashRegistryType getSlashRegistryType() {
        return SlashRegistryType.STATMOD;
    }

    @Override
    public int Weight() {
        return this.getRarity().Weight();
    }

    @Override
    public Rarity getRarity() {
        return Rarities.Gears.get(this.getRarityRank());
    }

    @Override
    public int getRarityRank() {
        return 1;
    }

    public abstract Stat GetBaseStat();

    public abstract float Min();

    public abstract float Max();

    public float minSecond() {
        return this.Min();
    }

    public float maxSecond() {
        return this.Max();
    }

    public boolean usesNumberRanges() {
        return this.getModType().equals((Object)StatModTypes.Flat) && this.Min() != this.minSecond() && this.Max() != this.maxSecond();
    }

    public final float getMin() {
        return this.Min() * this.size.multi;
    }

    public final float getMax() {
        return this.Max() * this.size.multi;
    }

    public final float getMinSecond() {
        return this.minSecond() * this.size.multi;
    }

    public final float getMaxSecond() {
        return this.maxSecond() * this.size.multi;
    }

    public abstract StatModTypes getModType();

    @Override
    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("min", (Number)Float.valueOf(this.Min()));
        json.addProperty("max", (Number)Float.valueOf(this.Max()));
        json.addProperty("min_second", (Number)Float.valueOf(this.minSecond()));
        json.addProperty("max_second", (Number)Float.valueOf(this.maxSecond()));
        json.addProperty("stat", this.GetBaseStat().GUID());
        json.addProperty("type", this.getModType().name());
        json.addProperty("guid", this.GUID());
        json.addProperty("size", this.size.name());
        return json;
    }

    @Override
    public StatMod fromJson(JsonObject json) {
        float min = json.get("min").getAsFloat();
        float max = json.get("max").getAsFloat();
        float min2 = json.get("min_second").getAsFloat();
        float max2 = json.get("max_second").getAsFloat();
        String stat = json.get("stat").getAsString();
        String guid = json.get("guid").getAsString();
        Size size = Size.valueOf(json.get("size").getAsString());
        StatModTypes type = StatModTypes.valueOf(json.get("type").getAsString());
        return new SerializableStatMod(stat, min, max, type, guid, size, min2, max2);
    }

    public static enum Size {
        TRIPLE_LESS("crippled_", -3.0f),
        DOUBLE_LESS("double_less_", -2.0f),
        ONE_LESS("much_less_", -1.0f),
        HALF_LESS("less_", -0.5f),
        QUARTER("tiny_", 0.25f),
        HALF("very_low_", 0.5f),
        LOW("low_", 0.75f),
        NORMAL("", 1.0f),
        HALF_MORE("high_", 1.5f),
        DOUBLE("very_high_", 2.0f),
        TRIPLE("major_", 3.0f);

        public String prefix;
        public float multi;

        private Size(String prefix, float multi) {
            this.prefix = prefix;
            this.multi = multi;
        }
    }
}

