/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.stats;

import com.robertx22.mine_and_slash.database.MinMax;
import com.robertx22.mine_and_slash.database.stats.Stat;
import com.robertx22.mine_and_slash.database.stats.types.traits.major_arcana.INameSuffix;
import com.robertx22.mine_and_slash.saveclasses.StatData;
import com.robertx22.mine_and_slash.saveclasses.gearitem.BaseStatContainer;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.TooltipInfo;
import com.robertx22.mine_and_slash.saveclasses.item_classes.tooltips.TooltipStatInfo;
import com.robertx22.mine_and_slash.saveclasses.spells.StatScaling;
import com.robertx22.mine_and_slash.uncommon.capability.entity.EntityCap;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Elements;
import com.robertx22.mine_and_slash.uncommon.interfaces.IAffectsOtherStats;
import com.robertx22.mine_and_slash.uncommon.localization.Styles;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class Trait
extends Stat
implements IAffectsOtherStats {
    public static String MAJOR_ARCANA = "\u25c8";
    public static String SYMBOL = "\u32a3";

    @Override
    public String locDescForLangFile() {
        return "";
    }

    @Override
    public void TryAffectOtherStats(EntityCap.UnitData unit, StatData data) {
        if (this.condition(unit)) {
            this.getAllStatContainers().applyStats(unit, unit.getLevel());
        }
    }

    public boolean condition(EntityCap.UnitData unit) {
        return true;
    }

    @Override
    public Elements getElement() {
        return null;
    }

    @Override
    public boolean IsPercent() {
        return false;
    }

    @Override
    public StatScaling getScaling() {
        return StatScaling.NONE;
    }

    @Override
    public boolean IsShownOnStatGui() {
        return false;
    }

    @Override
    public Stat.StatType getStatType() {
        return Stat.StatType.TRAIT;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ITextComponent TraitText(TooltipStatInfo info) {
        Stat basestat = info.stat;
        ITextComponent comp = Styles.GREENCOMP().func_150257_a(new StringTextComponent(" " + SYMBOL + " ").func_150257_a(basestat.locName()));
        if (basestat instanceof INameSuffix) {
            INameSuffix suffix = (INameSuffix)((Object)basestat);
            comp.func_150258_a(TextFormatting.LIGHT_PURPLE + " " + MAJOR_ARCANA + "  (");
            comp.func_150257_a(suffix.locSuffix().func_150258_a(") " + MAJOR_ARCANA));
        }
        return comp;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<ITextComponent> getTooltipList(TooltipStatInfo info) {
        ArrayList<ITextComponent> list = new ArrayList<ITextComponent>();
        Stat basestat = info.stat;
        StringTextComponent text = new StringTextComponent("");
        text = this.TraitText(info);
        list.add((ITextComponent)text);
        if ((info.useInDepthStats() || info.shouldShowDescriptions()) && basestat instanceof Trait) {
            Trait trait = (Trait)basestat;
            for (BaseStatContainer moddata : trait.getAllStatContainers().list) {
                TooltipInfo newinfo = info.tooltipInfo.withLevel(info.tooltipInfo.unitdata.getLevel());
                newinfo.minmax = new MinMax(trait.percent(), trait.percent());
                list.addAll(moddata.GetTooltipString(newinfo));
            }
        }
        if ((info.shouldShowDescriptions() || info.useInDepthStats()) && !this.locDescForLangFile().isEmpty()) {
            list.addAll(info.stat.getCutDescTooltip());
        }
        return list;
    }
}

