/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.stats.effects.defense;

import com.robertx22.mine_and_slash.database.stats.Stat;
import com.robertx22.mine_and_slash.database.stats.effects.base.BaseDamageEffect;
import com.robertx22.mine_and_slash.saveclasses.StatData;
import com.robertx22.mine_and_slash.uncommon.effectdatas.DamageEffect;
import com.robertx22.mine_and_slash.uncommon.interfaces.IStatEffect;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.SoundUtils;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.Vec3d;

public class BlockEffect
extends BaseDamageEffect {
    public static AttributeModifier MOD = new AttributeModifier(UUID.fromString("38400000-8cf0-11bd-b23e-10b96e4ef00d"), "mmorpgknockbackresist", 100.0, AttributeModifier.Operation.ADDITION);

    @Override
    public int GetPriority() {
        return IStatEffect.Priority.Last.priority;
    }

    @Override
    public IStatEffect.EffectSides Side() {
        return IStatEffect.EffectSides.Target;
    }

    @Override
    public DamageEffect activate(DamageEffect effect, StatData data, Stat stat) {
        float blockval = data.getAverageValue();
        float afterblock = effect.number - blockval;
        if (afterblock < 0.0f) {
            effect.isFullyBlocked = true;
            SoundUtils.playSound((Entity)effect.target, SoundEvents.field_187767_eL, 1.0f, 1.0f);
        } else {
            effect.isPartiallyBlocked = true;
            BlockEffect.applyKnockbackResist(effect.target);
            SoundUtils.playSound((Entity)effect.target, SoundEvents.field_187767_eL, 0.75f, 1.25f);
        }
        effect.number = afterblock;
        return effect;
    }

    @Override
    public boolean canActivate(DamageEffect effect, StatData data, Stat stat) {
        DamageSource dmgsource = DamageSource.func_76358_a((LivingEntity)effect.source);
        return this.canBlockDamageSource(effect.target, dmgsource);
    }

    public static void applyKnockbackResist(LivingEntity entity) {
        if (!entity.func_110148_a(SharedMonsterAttributes.field_111266_c).func_180374_a(MOD)) {
            entity.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111121_a(MOD);
        }
    }

    public static void removeKnockbackResist(LivingEntity entity) {
        if (entity.func_110148_a(SharedMonsterAttributes.field_111266_c).func_180374_a(MOD)) {
            entity.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111124_b(MOD);
        }
    }

    private boolean canBlockDamageSource(LivingEntity target, DamageSource damageSourceIn) {
        Vec3d vec3d;
        if (target.func_184585_cz() && (vec3d = damageSourceIn.func_188404_v()) != null) {
            Vec3d vec3d1 = target.func_70676_i(1.0f);
            Vec3d vec3d2 = vec3d.func_72444_a(new Vec3d(target.field_70165_t, target.field_70163_u, target.field_70161_v)).func_72432_b();
            vec3d2 = new Vec3d(vec3d2.field_72450_a, 0.0, vec3d2.field_72449_c);
            if (vec3d2.func_72430_b(vec3d1) < 0.0) {
                return true;
            }
        }
        return false;
    }
}

