/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.stats.effects.game_changers;

import com.robertx22.mine_and_slash.database.stats.Stat;
import com.robertx22.mine_and_slash.database.stats.effects.base.BaseDamageEffect;
import com.robertx22.mine_and_slash.database.stats.effects.defense.MagicShieldEffect;
import com.robertx22.mine_and_slash.saveclasses.ResourcesData;
import com.robertx22.mine_and_slash.saveclasses.StatData;
import com.robertx22.mine_and_slash.uncommon.effectdatas.DamageEffect;
import com.robertx22.mine_and_slash.uncommon.interfaces.IStatEffect;
import net.minecraft.util.math.MathHelper;

public class ManaBatteryEffect
extends BaseDamageEffect {
    public static final ManaBatteryEffect INSTANCE = new ManaBatteryEffect();

    @Override
    public int GetPriority() {
        return IStatEffect.Priority.beforeThis(MagicShieldEffect.INSTANCE.GetPriority());
    }

    @Override
    public IStatEffect.EffectSides Side() {
        return IStatEffect.EffectSides.Target;
    }

    @Override
    public DamageEffect activate(DamageEffect effect, StatData data, Stat stat) {
        float maxMana;
        float currentMana = effect.targetData.getResources().getMana();
        float dmgReduced = MathHelper.func_76131_a((float)(effect.number / 2.0f), (float)0.0f, (float)(currentMana - (maxMana = effect.targetData.getUnit().manaData().getAverageValue()) * 0.25f));
        if (dmgReduced > 0.0f) {
            effect.number -= dmgReduced;
            ResourcesData.Context ctx = new ResourcesData.Context(effect.targetData, effect.target, ResourcesData.Type.MANA, dmgReduced, ResourcesData.Use.SPEND);
            effect.targetData.getResources().modify(ctx);
        }
        return effect;
    }

    @Override
    public boolean canActivate(DamageEffect effect, StatData data, Stat stat) {
        float currentMana = effect.targetData.getResources().getMana();
        return currentMana / effect.targetData.getUnit().manaData().getAverageValue() > 0.25f;
    }
}

