/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.stats.effects.game_changers;

import com.robertx22.mine_and_slash.database.stats.Stat;
import com.robertx22.mine_and_slash.database.stats.effects.base.BaseDamageEffect;
import com.robertx22.mine_and_slash.database.stats.types.game_changers.RefreshingBreeze;
import com.robertx22.mine_and_slash.database.stats.types.resources.EnergyRegen;
import com.robertx22.mine_and_slash.saveclasses.ResourcesData;
import com.robertx22.mine_and_slash.saveclasses.StatData;
import com.robertx22.mine_and_slash.uncommon.effectdatas.DamageEffect;
import com.robertx22.mine_and_slash.uncommon.interfaces.IStatEffect;

public class RefreshingBreezeEffect
extends BaseDamageEffect {
    public static final RefreshingBreezeEffect INSTANCE = new RefreshingBreezeEffect();

    @Override
    public int GetPriority() {
        return IStatEffect.Priority.Last.priority;
    }

    @Override
    public IStatEffect.EffectSides Side() {
        return IStatEffect.EffectSides.Target;
    }

    @Override
    public DamageEffect activate(DamageEffect effect, StatData data, Stat stat) {
        ResourcesData.Use use;
        float energy = effect.targetData.getUnit().peekAtStat(EnergyRegen.GUID).getAverageValue() * (float)RefreshingBreeze.PERCENT / 100.0f;
        if (effect.isDodged) {
            use = ResourcesData.Use.RESTORE;
        } else {
            use = ResourcesData.Use.SPEND;
            energy /= 4.0f;
        }
        ResourcesData.Context ene = new ResourcesData.Context(effect.targetData, effect.target, ResourcesData.Type.ENERGY, energy, use);
        effect.targetData.getResources().modify(ene);
        return effect;
    }

    @Override
    public boolean canActivate(DamageEffect effect, StatData data, Stat stat) {
        return true;
    }
}

