/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.stats.effects.offense;

import com.robertx22.mine_and_slash.database.stats.Stat;
import com.robertx22.mine_and_slash.database.stats.effects.base.BaseDamageEffect;
import com.robertx22.mine_and_slash.database.stats.effects.defense.BlockEffect;
import com.robertx22.mine_and_slash.database.stats.types.resources.Energy;
import com.robertx22.mine_and_slash.saveclasses.ResourcesData;
import com.robertx22.mine_and_slash.saveclasses.StatData;
import com.robertx22.mine_and_slash.uncommon.effectdatas.DamageEffect;
import com.robertx22.mine_and_slash.uncommon.effectdatas.EffectData;
import com.robertx22.mine_and_slash.uncommon.effectdatas.interfaces.WeaponTypes;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Elements;
import com.robertx22.mine_and_slash.uncommon.interfaces.IStatEffect;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.SoundUtils;
import net.minecraft.entity.Entity;
import net.minecraft.util.SoundEvents;

public class BlockReflectEffect
extends BaseDamageEffect {
    public Elements element = Elements.Physical;

    public BlockReflectEffect(Elements element) {
        this.element = element;
    }

    @Override
    public int GetPriority() {
        return IStatEffect.Priority.afterThis(new BlockEffect().GetPriority());
    }

    @Override
    public IStatEffect.EffectSides Side() {
        return IStatEffect.EffectSides.Target;
    }

    public float getEnergyCost(int lvl) {
        return Energy.getInstance().getScaling().scale(1.0f, lvl);
    }

    @Override
    public DamageEffect activate(DamageEffect effect, StatData data, Stat stat) {
        float cost = this.getEnergyCost(effect.targetData.getLevel());
        ResourcesData.Context ctx = new ResourcesData.Context(effect.targetData, effect.target, ResourcesData.Type.ENERGY, cost, ResourcesData.Use.SPEND);
        effect.targetData.getResources().modify(ctx);
        float dmg = data.getAverageValue();
        DamageEffect dmgeffect = new DamageEffect(null, effect.target, effect.source, (int)dmg, effect.targetData, effect.sourceData, EffectData.EffectTypes.REFLECT, WeaponTypes.None);
        dmgeffect.element = stat.getElement();
        SoundUtils.playSound((Entity)effect.target, SoundEvents.field_187767_eL, 1.0f, 2.0f);
        dmgeffect.Activate();
        return effect;
    }

    @Override
    public boolean canActivate(DamageEffect effect, StatData data, Stat stat) {
        if (effect.getEffectType().equals((Object)EffectData.EffectTypes.BASIC_ATTACK) && effect.isBlocked()) {
            float cost = this.getEnergyCost(effect.targetData.getLevel());
            ResourcesData.Context ctx = new ResourcesData.Context(effect.targetData, effect.target, ResourcesData.Type.ENERGY, cost, ResourcesData.Use.SPEND);
            return effect.targetData.getResources().hasEnough(ctx);
        }
        return false;
    }
}

