/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.stats.effects.resource;

import com.robertx22.mine_and_slash.database.stats.Stat;
import com.robertx22.mine_and_slash.database.stats.effects.base.BaseDamageEffect;
import com.robertx22.mine_and_slash.saveclasses.StatData;
import com.robertx22.mine_and_slash.uncommon.effectdatas.DamageEffect;
import com.robertx22.mine_and_slash.uncommon.effectdatas.EffectData;
import com.robertx22.mine_and_slash.uncommon.interfaces.IStatEffect;

public class MagicStealEffect
extends BaseDamageEffect {
    private MagicStealEffect() {
    }

    public static MagicStealEffect getInstance() {
        return SingletonHolder.INSTANCE;
    }

    @Override
    public int GetPriority() {
        return IStatEffect.Priority.Last.priority;
    }

    @Override
    public IStatEffect.EffectSides Side() {
        return IStatEffect.EffectSides.Source;
    }

    @Override
    public DamageEffect activate(DamageEffect effect, StatData data, Stat stat) {
        float healed = Math.max(1.0f, data.getAverageValue() * effect.number / 100.0f);
        effect.magicShieldRestored += healed;
        return effect;
    }

    @Override
    public boolean canActivate(DamageEffect effect, StatData data, Stat stat) {
        return effect.getEffectType().equals((Object)EffectData.EffectTypes.BASIC_ATTACK);
    }

    private static class SingletonHolder {
        private static final MagicStealEffect INSTANCE = new MagicStealEffect();

        private SingletonHolder() {
        }
    }
}

