/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.stats.tooltips;

import com.robertx22.mine_and_slash.database.stats.Stat;
import com.robertx22.mine_and_slash.database.stats.tooltips.IStatTooltipType;
import com.robertx22.mine_and_slash.saveclasses.item_classes.tooltips.TooltipStatInfo;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Elements;
import com.robertx22.mine_and_slash.uncommon.enumclasses.StatModTypes;
import com.robertx22.mine_and_slash.uncommon.localization.Styles;
import com.robertx22.mine_and_slash.uncommon.localization.Words;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;

public class NormalStatTooltip
implements IStatTooltipType {
    @Override
    public List<ITextComponent> getTooltipList(TooltipStatInfo info) {
        ArrayList<ITextComponent> list = new ArrayList<ITextComponent>();
        ITextComponent text = this.getValueComp(info).func_150258_a(" ").func_150257_a(this.getStatComp(info)).func_150257_a(StatModTypes.getSuffix(info.type));
        if (info.useInDepthStats() && info.statRange != null) {
            text.func_150257_a(this.getNumberRanges(info.statRange));
        }
        list.add(text);
        if (info.shouldShowDescriptions()) {
            list.addAll(info.stat.getCutDescTooltip());
        }
        return list;
    }

    private ITextComponent getStatComp(TooltipStatInfo info) {
        Stat stat = info.stat;
        StringTextComponent str = new StringTextComponent("");
        if (info.stat.getElement() == null || info.stat.getElement() != Elements.Physical) {
            // empty if block
        }
        if (info.type.equals((Object)StatModTypes.Percent) && stat.IsPercent()) {
            if (info.firstValue > 0.0f) {
                str.func_150257_a(Words.Increased.locName());
            } else {
                str.func_150257_a(Words.Decreased.locName());
            }
            str.func_150258_a(" ");
        }
        str.func_150257_a(stat.locName());
        if (!info.tooltipInfo.isSet) {
            return Styles.GRAYCOMP().func_150257_a((ITextComponent)str);
        }
        return Styles.GREENCOMP().func_150257_a((ITextComponent)str);
    }

    private ITextComponent getValueComp(TooltipStatInfo info) {
        float v1 = info.firstValue;
        float v2 = info.secondValue;
        String minusplus = v1 > 0.0f ? "+" : "";
        TextFormatting color = TextFormatting.GREEN;
        if (v1 < 0.0f) {
            color = TextFormatting.RED;
        }
        StringTextComponent comp = new StringTextComponent("");
        if (v1 == v2) {
            comp.func_150258_a(color + minusplus + info.stat.printValue(v1));
            comp.func_150257_a(StatModTypes.getNumberSuffix(info.type, info.stat));
            comp.func_150258_a(TextFormatting.RESET + "");
        } else {
            comp.func_150258_a(color + minusplus + info.stat.printValue(v1) + "-" + info.stat.printValue(v2));
            comp.func_150257_a(StatModTypes.getNumberSuffix(info.type, info.stat));
            comp.func_150258_a(TextFormatting.RESET + "");
        }
        return comp;
    }
}

