/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.stats.tooltips;

import com.robertx22.mine_and_slash.database.stats.Stat;
import com.robertx22.mine_and_slash.database.stats.tooltips.IStatTooltipType;
import com.robertx22.mine_and_slash.saveclasses.item_classes.tooltips.TooltipStatInfo;
import com.robertx22.mine_and_slash.uncommon.enumclasses.StatModTypes;
import com.robertx22.mine_and_slash.uncommon.localization.Styles;
import com.robertx22.mine_and_slash.uncommon.localization.Words;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PrimaryStatTooltip
implements IStatTooltipType {
    public ITextComponent NameText(TooltipStatInfo info) {
        Stat stat = info.stat;
        StringTextComponent str = new StringTextComponent("");
        if (!info.type.equals((Object)StatModTypes.Flat) || stat.IsPercent()) {
            // empty if block
        }
        str.func_150257_a(stat.locName());
        if (!info.tooltipInfo.isSet) {
            return Styles.REDCOMP().func_150257_a(new StringTextComponent(" " + stat.getFormattedIcon() + " ").func_150257_a((ITextComponent)str).func_150258_a(": "));
        }
        return Styles.GREENCOMP().func_150257_a(str.func_150258_a(": "));
    }

    @OnlyIn(value=Dist.CLIENT)
    public ITextComponent NameAndValueText(TooltipStatInfo info) {
        float v1 = info.firstValue;
        float v2 = info.secondValue;
        if (v1 == v2) {
            String test = v1 + "";
            boolean hasMinus = test.contains("-");
            String minusplus = "";
            if (!hasMinus && v1 < 0.0f) {
                minusplus = "-";
            }
            return this.NameText(info).func_150258_a(minusplus + info.stat.printValue(v1));
        }
        String minusplus = v1 > 0.0f ? "" : "-";
        String str = minusplus + info.stat.printValue(v1) + "-" + info.stat.printValue(v2);
        return this.NameText(info).func_150258_a(str);
    }

    @Override
    public List<ITextComponent> getTooltipList(TooltipStatInfo info) {
        ArrayList<ITextComponent> list = new ArrayList<ITextComponent>();
        StatModTypes type = info.type;
        Stat stat = info.stat;
        ITextComponent text = this.NameAndValueText(info);
        if (type == StatModTypes.Flat) {
            if (stat.IsPercent()) {
                text.func_150258_a("%");
            }
        } else if (type == StatModTypes.Multi) {
            text.func_150258_a("% ").func_150257_a(Words.Multi.locName());
        } else if (type == StatModTypes.Percent) {
            text.func_150258_a("%");
            if (type == StatModTypes.Percent && stat.IsPercent()) {
                if (info.firstValue > 0.0f) {
                    text.func_150258_a(" ").func_150257_a(Words.Increased.locName());
                } else {
                    text.func_150258_a(" ").func_150257_a(Words.Decreased.locName());
                }
            }
        }
        if (info.useInDepthStats() && info.statRange != null) {
            text.func_150257_a(this.getNumberRanges(info.statRange));
        }
        list.add(text);
        if (info.shouldShowDescriptions()) {
            list.addAll(info.stat.getCutDescTooltip());
        }
        return list;
    }
}

