/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.stats.types.game_changers;

import com.robertx22.mine_and_slash.database.stats.TransferMethod;
import com.robertx22.mine_and_slash.database.stats.types.game_changers.BaseGameChangerTrait;
import com.robertx22.mine_and_slash.database.stats.types.resources.Health;
import com.robertx22.mine_and_slash.database.stats.types.resources.MagicShield;
import com.robertx22.mine_and_slash.saveclasses.ExactStatData;
import com.robertx22.mine_and_slash.saveclasses.StatData;
import com.robertx22.mine_and_slash.saveclasses.Unit;
import com.robertx22.mine_and_slash.uncommon.enumclasses.StatModTypes;
import com.robertx22.mine_and_slash.uncommon.interfaces.IStatTransfer;
import java.util.Arrays;
import java.util.List;

public class MagicalLife
extends BaseGameChangerTrait
implements IStatTransfer {
    public static final MagicalLife INSTANCE = new MagicalLife();

    private MagicalLife() {
    }

    @Override
    public String locDescForLangFile() {
        return "Transforms your magic shield into health.";
    }

    @Override
    public String getIconPath() {
        return "game_changers/magical_life";
    }

    @Override
    public String locNameForLangFile() {
        return "Magical Life";
    }

    @Override
    public List<TransferMethod> Transfer() {
        return Arrays.asList(new TransferMethod(MagicShield.getInstance(), Health.getInstance()));
    }

    @Override
    public List<ExactStatData> getExactStats() {
        return Arrays.asList(new ExactStatData(-25.0f, StatModTypes.Multi, MagicShield.getInstance()));
    }

    @Override
    public String GUID() {
        return "magical_life_trait";
    }

    @Override
    public void transferStats(Unit copy, Unit unit, StatData data) {
        for (TransferMethod stat : this.Transfer()) {
            float val = copy.peekAtStat(stat.converted.GUID()).getFlatAverage();
            if (val == 0.0f) continue;
            unit.getCreateStat(stat.converted).addFlat(-val);
            unit.getCreateStat(stat.statThatBenefits).addFlat(val);
        }
    }
}

