/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.stats.types.generated;

import com.robertx22.mine_and_slash.database.stats.Stat;
import com.robertx22.mine_and_slash.database.stats.effects.offense.ElementalPeneEffect;
import com.robertx22.mine_and_slash.database.stats.types.ElementalStat;
import com.robertx22.mine_and_slash.saveclasses.spells.StatScaling;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Elements;
import com.robertx22.mine_and_slash.uncommon.interfaces.IStatEffect;
import com.robertx22.mine_and_slash.uncommon.interfaces.IStatEffects;
import com.robertx22.mine_and_slash.uncommon.wrappers.MapWrapper;
import java.util.List;

public class ElementalPene
extends ElementalStat
implements IStatEffects {
    public static MapWrapper<Elements, ElementalPene> MAP = new MapWrapper();

    @Override
    public List<Stat> generateAllPossibleStatVariations() {
        List<Stat> list = super.generateAllPossibleStatVariations();
        list.forEach(x -> MAP.put(x.getElement(), (ElementalPene)x));
        return list;
    }

    @Override
    public StatScaling getScaling() {
        return StatScaling.SLOW_SCALING;
    }

    @Override
    public Stat.StatGroup statGroup() {
        return Stat.StatGroup.Penetration;
    }

    public ElementalPene(Elements element) {
        super(element);
        this.minimumValue = 0.0f;
    }

    @Override
    public Stat newGeneratedInstance(Elements element) {
        return new ElementalPene(element);
    }

    @Override
    public String getIconPath() {
        return "pene/" + this.element.guidName;
    }

    @Override
    public String GUID() {
        return this.getElement().guidName + "_penetration";
    }

    @Override
    public String locDescForLangFile() {
        return "Ignores that much resists, it works as subtraction.";
    }

    @Override
    public String locDescLangFileGUID() {
        return "mmorpg.stat_desc.ele_pene";
    }

    @Override
    public boolean IsPercent() {
        return true;
    }

    @Override
    public String locNameForLangFile() {
        return this.getElement().name() + " Penetration";
    }

    @Override
    public IStatEffect getEffect() {
        return new ElementalPeneEffect();
    }
}

