/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.talent_tree;

import com.robertx22.mine_and_slash.database.talent_tree.BasePerkEffect;
import com.robertx22.mine_and_slash.database.talent_tree.PerkConnection;
import com.robertx22.mine_and_slash.database.talent_tree.PerkType;
import com.robertx22.mine_and_slash.db_lists.Rarities;
import com.robertx22.mine_and_slash.registry.ISlashRegistryEntry;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.Rarity;
import com.robertx22.mine_and_slash.saveclasses.talents.BasePerksData;
import com.robertx22.mine_and_slash.uncommon.capability.bases.IPerkCap;
import java.util.ArrayList;
import java.util.List;

public abstract class BasePerk<T extends BasePerk, C extends IPerkCap>
implements ISlashRegistryEntry<T> {
    public List<T> connections = new ArrayList<T>();
    public BasePerkEffect effect;
    protected String guid;
    public int x;
    public int y;
    public boolean isStart = false;

    public BasePerk(String guid) {
        this.guid = guid;
    }

    public boolean isConnectedTo(T talent) {
        for (BasePerk con : this.connections) {
            if (!con.GUID().equals(((BasePerk)talent).GUID())) continue;
            return true;
        }
        return false;
    }

    public abstract void render(int var1, int var2);

    public PerkType getPerkType() {
        if (this.effect.getPerkType() == PerkType.MAJOR) {
            if (this.effect.isGameChanger()) {
                return this.effect.getPerkType();
            }
            return PerkType.BIG;
        }
        return this.effect.getPerkType();
    }

    public boolean tryConnectTo(T other) {
        if (this.equals(other)) {
            return false;
        }
        boolean added = false;
        if (!this.connections.contains(other)) {
            this.connections.add(other);
            added = true;
        }
        if (!((BasePerk)other).connections.contains(this)) {
            ((BasePerk)other).connections.add(this);
            added = true;
        }
        return added;
    }

    public PerkConnection.Allocation getStatus(IPerkCap data) {
        if (((BasePerksData)data.getAbilitiesData()).isAllocated((BasePerk)this)) {
            return PerkConnection.Allocation.ALLOCATED;
        }
        if (this.isStart && data.getAllocatedPoints() == 0) {
            return PerkConnection.Allocation.CAN_ALLOCATE;
        }
        boolean hascon = false;
        for (BasePerk con : this.connections) {
            if (!((BasePerksData)data.getAbilitiesData()).isAllocated((BasePerk)con)) continue;
            hascon = true;
        }
        if (hascon) {
            return PerkConnection.Allocation.CAN_ALLOCATE;
        }
        return PerkConnection.Allocation.CANT_ALLOCATE;
    }

    @Override
    public int Weight() {
        return 1000;
    }

    @Override
    public int getRarityRank() {
        return 0;
    }

    @Override
    public Rarity getRarity() {
        return Rarities.Gears.get(this.getRarityRank());
    }

    @Override
    public String GUID() {
        return this.guid;
    }
}

