/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.talent_tree;

import com.robertx22.mine_and_slash.database.talent_tree.BasePerk;
import com.robertx22.mine_and_slash.database.talent_tree.BasePerkEffect;
import com.robertx22.mine_and_slash.database.talent_tree.Perk;

public class PerkBuilder {
    public static Guid create(String id) {
        return new Guid(id);
    }

    public static class Connections {
        private BasePerk talent;

        public Connections(BasePerk talent) {
            this.talent = talent;
        }

        public Connections add(BasePerk other) {
            this.talent.tryConnectTo(other);
            return this;
        }

        public BasePerk build() {
            this.talent.registerToSlashRegistry();
            return this.talent;
        }
    }

    public static class Effect {
        private BasePerk talent;

        public Effect(BasePerk talent, BasePerkEffect effect) {
            this.talent = talent;
            talent.effect = effect;
        }

        public Connections connections() {
            return new Connections(this.talent);
        }
    }

    public static class Position {
        private BasePerk talent;

        public Position(BasePerk talent, int x, int y) {
            this.talent = talent;
            this.talent.x = x;
            this.talent.y = y;
        }

        public Effect effect(BasePerkEffect effect) {
            return new Effect(this.talent, effect);
        }

        public Connections copy(Perk other) {
            return this.effect(other.effect).connections();
        }
    }

    public static class Guid {
        private Perk talent;

        public Guid(String guid) {
            this.talent = new Perk(guid);
        }

        public Position pos(int x, int y) {
            return new Position(this.talent, x, y);
        }
    }
}

