/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.talent_tree;

import com.robertx22.mine_and_slash.database.stats.Stat;
import com.robertx22.mine_and_slash.database.talent_tree.BasePerkEffect;
import com.robertx22.mine_and_slash.database.talent_tree.PerkType;
import com.robertx22.mine_and_slash.database.talent_tree.RenderUtils;
import com.robertx22.mine_and_slash.registry.ISlashRegistryEntry;
import com.robertx22.mine_and_slash.registry.SlashRegistryType;
import com.robertx22.mine_and_slash.saveclasses.ExactStatData;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.IApplyableStats;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.TooltipInfo;
import com.robertx22.mine_and_slash.uncommon.capability.entity.EntityCap;
import com.robertx22.mine_and_slash.uncommon.localization.Words;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;

public class PerkEffect
extends BasePerkEffect
implements IApplyableStats,
ISlashRegistryEntry<PerkEffect> {
    public List<ExactStatData> exactStats;

    public PerkEffect setGameChanger() {
        this.isGameChanger = true;
        return this;
    }

    public PerkEffect(String guid, List<ExactStatData> exactStats, String render) {
        this.exactStats = exactStats;
        this.guid = guid;
        this.registerToSlashRegistry();
    }

    public PerkEffect(String guid, ExactStatData exactStat, Stat stat) {
        this.exactStats = Arrays.asList(exactStat);
        this.guid = guid;
        if (stat != null) {
            this.setupTexture(stat);
        }
        this.registerToSlashRegistry();
    }

    public PerkEffect(String guid, ExactStatData exactStat, String render) {
        this.exactStats = Arrays.asList(exactStat);
        this.guid = guid;
        if (render != null) {
            this.setupTexture(render);
        }
        this.registerToSlashRegistry();
    }

    @Override
    public boolean isGameChanger() {
        return this.isGameChanger;
    }

    private void setupTexture(Stat stat) {
        this.TEXTURE = stat.getIconLocation();
        this.hasTexture = true;
    }

    private void setupTexture(String id) {
        this.TEXTURE = new ResourceLocation("mmorpg", "textures/gui/talents/icons/" + id + ".png");
        this.hasTexture = !id.isEmpty();
    }

    public PerkEffect type(PerkType type) {
        this.type = type;
        return this;
    }

    public ITextComponent getName() {
        return null;
    }

    @Override
    public List<ITextComponent> GetTooltipString(TooltipInfo info) {
        ArrayList<ITextComponent> list = new ArrayList<ITextComponent>();
        int before = list.size();
        this.exactStats.forEach(x -> list.addAll(x.GetTooltipString(info)));
        int after = list.size();
        if (after > before && !Screen.hasAltDown() && !Screen.hasShiftDown()) {
            if (this.isGameChanger()) {
                list.add(new StringTextComponent(TextFormatting.BLUE + "[").func_150257_a(Words.Press_Shift_For_More_Info.locName()).func_150258_a("]"));
            }
            list.add(new StringTextComponent(TextFormatting.BLUE + "[").func_150257_a(Words.PressAltForStatInfo.locName()).func_150258_a("]"));
        }
        return list;
    }

    @Override
    public void applyStats(EntityCap.UnitData data, int level) {
        this.exactStats.forEach(x -> x.applyStats(data, level));
    }

    @Override
    public void render(int x, int y) {
        if (!this.hasTexture) {
            if (this.exactStats.size() > 1) {
                RenderUtils.renderIcons(this.exactStats, x, y);
            }
        } else if (this.isGameChanger && this.getPerkType().equals((Object)PerkType.MAJOR)) {
            RenderUtils.render32Icon(this.TEXTURE, x, y);
        } else {
            RenderUtils.render16Icon(this.TEXTURE, x, y);
        }
    }

    @Override
    public SlashRegistryType getSlashRegistryType() {
        return SlashRegistryType.PERK_EFFECT;
    }

    @Override
    public String GUID() {
        return this.guid;
    }
}

