/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.talent_tree.csv_parser;

import com.robertx22.mine_and_slash.database.talent_tree.BasePerk;
import com.robertx22.mine_and_slash.database.talent_tree.Perk;
import com.robertx22.mine_and_slash.database.talent_tree.PerkBuilder;
import com.robertx22.mine_and_slash.database.talent_tree.PerkEffect;
import com.robertx22.mine_and_slash.database.talent_tree.csv_parser.GridPoint;
import com.robertx22.mine_and_slash.database.talent_tree.data.StartPerkEffects;
import com.robertx22.mine_and_slash.registry.SlashRegistry;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;

public class PerkGrid<T extends GridPoint> {
    protected List<List<T>> grid = new ArrayList<List<T>>();

    public T get(int x, int y) {
        return (T)((GridPoint)this.grid.get(x).get(y));
    }

    public T newGridPoint(int x, int y, String s) {
        return (T)new GridPoint(x, y, s);
    }

    public PerkGrid(String str) {
        int y = 0;
        for (String line : str.split("\n")) {
            int x = 0;
            for (String s : line.split(",")) {
                if (this.grid.size() <= x) {
                    this.grid.add(new ArrayList());
                }
                this.grid.get(x).add(this.newGridPoint(x, y, s));
                ++x;
            }
            ++y;
        }
    }

    public void createConnections() {
        ArrayList<GridPoint> talents = new ArrayList<GridPoint>();
        for (List<T> list : this.grid) {
            for (GridPoint point : list) {
                if (!point.isTalent()) continue;
                talents.add(point);
            }
        }
        for (GridPoint one : talents) {
            for (GridPoint two : talents) {
                if (!this.hasPath(one, two)) continue;
                ((BasePerk)one.getPerk()).tryConnectTo(two.getPerk());
            }
        }
    }

    private boolean hasPath(T start, T end) {
        ArrayDeque<Object> openSet = new ArrayDeque<Object>();
        openSet.add(start);
        HashSet<GridPoint> closedSet = new HashSet<GridPoint>();
        while (!openSet.isEmpty()) {
            GridPoint current = (GridPoint)openSet.poll();
            if (current.equals(end)) {
                return true;
            }
            if (!closedSet.add(current) || current.isTalent() && current != start) continue;
            openSet.addAll(this.getEligibleSurroundingPoints(current));
        }
        return false;
    }

    public List<T> getEligibleSurroundingPoints(T p) {
        ArrayList<T> list = new ArrayList<T>();
        int x = ((GridPoint)p).x;
        int y = ((GridPoint)p).y;
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dy = -1; dy <= 1; ++dy) {
                if (dx == 0 && dy == 0 || !this.isInRange(x + dx, y + dy)) continue;
                T point = this.get(x + dx, y + dy);
                if (Math.abs(dx) == 1 && Math.abs(dy) == 1 && (((GridPoint)this.get(x + dx, y)).isTalent() || ((GridPoint)this.get(x, y + dy)).isTalent()) || !((GridPoint)point).isTalent() && !((GridPoint)point).isConnector()) continue;
                list.add(point);
            }
        }
        return list;
    }

    public boolean isInRange(int x, int y) {
        if (y < 2) {
            return false;
        }
        try {
            return this.get(x, y) != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void createAndRegisterAll() {
        for (List<T> list : this.grid) {
            for (GridPoint point : list) {
                if (!point.isTalent()) continue;
                String id = point.getEffectID();
                if (!SlashRegistry.PerkEffects().isRegistered(id)) {
                    id = id.toLowerCase(Locale.ROOT);
                }
                PerkEffect effect = null;
                if (SlashRegistry.PerkEffects().isRegistered(id)) {
                    effect = SlashRegistry.PerkEffects().get(id);
                }
                if (effect == null) {
                    effect = StartPerkEffects.WARRIOR;
                    System.out.println(point.getID() + ": " + point.getEffectIDRaw() + " is a broken talent.");
                }
                Perk perk = (Perk)PerkBuilder.create(point.getID()).pos(point.x, point.y).effect(effect).connections().build();
            }
        }
    }
}

