/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.unique_items;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.robertx22.mine_and_slash.data_generation.JsonUtils;
import com.robertx22.mine_and_slash.data_generation.unique_gears.SerializableUniqueGear;
import com.robertx22.mine_and_slash.database.gearitemslots.cloth.ClothBoots;
import com.robertx22.mine_and_slash.database.gearitemslots.cloth.ClothChest;
import com.robertx22.mine_and_slash.database.gearitemslots.cloth.ClothHelmet;
import com.robertx22.mine_and_slash.database.gearitemslots.cloth.ClothPants;
import com.robertx22.mine_and_slash.database.gearitemslots.curios.Bracelet;
import com.robertx22.mine_and_slash.database.gearitemslots.curios.Charm;
import com.robertx22.mine_and_slash.database.gearitemslots.curios.Necklace;
import com.robertx22.mine_and_slash.database.gearitemslots.curios.Ring;
import com.robertx22.mine_and_slash.database.gearitemslots.leather.LeatherBoots;
import com.robertx22.mine_and_slash.database.gearitemslots.leather.LeatherChest;
import com.robertx22.mine_and_slash.database.gearitemslots.leather.LeatherHelmet;
import com.robertx22.mine_and_slash.database.gearitemslots.leather.LeatherPants;
import com.robertx22.mine_and_slash.database.gearitemslots.offhand.Shield;
import com.robertx22.mine_and_slash.database.gearitemslots.plate.PlateBoots;
import com.robertx22.mine_and_slash.database.gearitemslots.plate.PlateChest;
import com.robertx22.mine_and_slash.database.gearitemslots.plate.PlateHelmet;
import com.robertx22.mine_and_slash.database.gearitemslots.plate.PlatePants;
import com.robertx22.mine_and_slash.database.gearitemslots.weapons.Axe;
import com.robertx22.mine_and_slash.database.gearitemslots.weapons.Bow;
import com.robertx22.mine_and_slash.database.gearitemslots.weapons.Hammer;
import com.robertx22.mine_and_slash.database.gearitemslots.weapons.Staff;
import com.robertx22.mine_and_slash.database.gearitemslots.weapons.Sword;
import com.robertx22.mine_and_slash.database.rarities.GearRarity;
import com.robertx22.mine_and_slash.database.stats.StatMod;
import com.robertx22.mine_and_slash.database.unique_items.ISpecificStatReq;
import com.robertx22.mine_and_slash.database.unique_items.StatReq;
import com.robertx22.mine_and_slash.database.unique_items.bases.BaseUniqueAxe;
import com.robertx22.mine_and_slash.database.unique_items.bases.BaseUniqueBoots;
import com.robertx22.mine_and_slash.database.unique_items.bases.BaseUniqueBow;
import com.robertx22.mine_and_slash.database.unique_items.bases.BaseUniqueBracelet;
import com.robertx22.mine_and_slash.database.unique_items.bases.BaseUniqueCharm;
import com.robertx22.mine_and_slash.database.unique_items.bases.BaseUniqueChest;
import com.robertx22.mine_and_slash.database.unique_items.bases.BaseUniqueHammer;
import com.robertx22.mine_and_slash.database.unique_items.bases.BaseUniqueHelmet;
import com.robertx22.mine_and_slash.database.unique_items.bases.BaseUniqueNecklace;
import com.robertx22.mine_and_slash.database.unique_items.bases.BaseUniquePantsItem;
import com.robertx22.mine_and_slash.database.unique_items.bases.BaseUniqueRing;
import com.robertx22.mine_and_slash.database.unique_items.bases.BaseUniqueShield;
import com.robertx22.mine_and_slash.database.unique_items.bases.BaseUniqueStaff;
import com.robertx22.mine_and_slash.database.unique_items.bases.BaseUniqueSword;
import com.robertx22.mine_and_slash.db_lists.Rarities;
import com.robertx22.mine_and_slash.onevent.data_gen.ISerializable;
import com.robertx22.mine_and_slash.onevent.data_gen.ISerializedRegistryEntry;
import com.robertx22.mine_and_slash.registry.SlashRegistryType;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.Rarity;
import com.robertx22.mine_and_slash.uncommon.interfaces.IAutoLocDesc;
import com.robertx22.mine_and_slash.uncommon.interfaces.IAutoLocName;
import com.robertx22.mine_and_slash.uncommon.interfaces.IBaseAutoLoc;
import com.robertx22.mine_and_slash.uncommon.interfaces.data_items.IGearSlotType;
import com.robertx22.mine_and_slash.uncommon.interfaces.data_items.IRarity;
import com.robertx22.mine_and_slash.uncommon.interfaces.data_items.ITiered;
import java.util.HashMap;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public interface IUnique
extends ISpecificStatReq,
IRarity,
IGearSlotType,
ITiered,
IAutoLocName,
IAutoLocDesc,
ISerializedRegistryEntry<IUnique>,
ISerializable<IUnique> {
    public static final HashMap<String, Supplier<Item>> BASE_UNIQUE_ITEMS = new HashMap<String, Supplier<Item>>(){
        {
            this.put(Sword.INSTANCE.GUID(), () -> new BaseUniqueSword());
            this.put(Staff.INSTANCE.GUID(), () -> new BaseUniqueStaff());
            this.put(Axe.INSTANCE.GUID(), () -> new BaseUniqueAxe());
            this.put(Bow.INSTANCE.GUID(), () -> new BaseUniqueBow());
            this.put(Hammer.INSTANCE.GUID(), () -> new BaseUniqueHammer());
            this.put(Shield.INSTANCE.GUID(), () -> new BaseUniqueShield());
            this.put(ClothBoots.INSTANCE.GUID(), () -> new BaseUniqueBoots());
            this.put(LeatherBoots.INSTANCE.GUID(), () -> new BaseUniqueBoots());
            this.put(PlateBoots.INSTANCE.GUID(), () -> new BaseUniqueBoots());
            this.put(ClothPants.INSTANCE.GUID(), () -> new BaseUniquePantsItem());
            this.put(LeatherPants.INSTANCE.GUID(), () -> new BaseUniquePantsItem());
            this.put(PlatePants.INSTANCE.GUID(), () -> new BaseUniquePantsItem());
            this.put(ClothChest.INSTANCE.GUID(), () -> new BaseUniqueChest());
            this.put(LeatherChest.INSTANCE.GUID(), () -> new BaseUniqueChest());
            this.put(PlateChest.INSTANCE.GUID(), () -> new BaseUniqueChest());
            this.put(ClothHelmet.INSTANCE.GUID(), () -> new BaseUniqueHelmet());
            this.put(LeatherHelmet.INSTANCE.GUID(), () -> new BaseUniqueHelmet());
            this.put(PlateHelmet.INSTANCE.GUID(), () -> new BaseUniqueHelmet());
            this.put(Ring.INSTANCE.GUID(), () -> new BaseUniqueRing());
            this.put(Charm.INSTANCE.GUID(), () -> new BaseUniqueCharm());
            this.put(Necklace.INSTANCE.GUID(), () -> new BaseUniqueNecklace());
            this.put(Bracelet.INSTANCE.GUID(), () -> new BaseUniqueBracelet());
        }
    };

    @Override
    default public boolean isFromDatapack() {
        return true;
    }

    @Override
    default public String datapackFolder() {
        return this.getGearSlot().GUID() + "/";
    }

    @Override
    default public JsonObject toJson() {
        JsonObject json = this.getDefaultJson();
        JsonUtils.addStatMods(this.primaryStats(), json, "primary_stats");
        JsonUtils.addStatMods(this.uniqueStats(), json, "unique_stats");
        json.addProperty("can_get_set", Boolean.valueOf(this.canGetSet()));
        json.add("requirements", (JsonElement)this.getRequirements().toJson());
        json.addProperty("gear_type", this.getGearSlot().GUID());
        json.addProperty("item_id", this.getResourceLocForItem().toString());
        return json;
    }

    @Override
    default public IUnique fromJson(JsonObject json) {
        String guid = this.getGUIDFromJson(json);
        String name = this.getLangNameStringFromJson(json);
        String desc = this.getLangDescStringFromJson(json);
        int tier = this.getTierFromJson(json);
        int weight = this.getWeightFromJson(json);
        GearRarity rarity = (GearRarity)Rarities.Gears.get(this.getRarityFromJson(json));
        ResourceLocation loc = new ResourceLocation(json.get("item_id").getAsString());
        List<StatMod> primary = JsonUtils.getStatMods(json, "primary_stats");
        List<StatMod> unique = JsonUtils.getStatMods(json, "unique_stats");
        boolean canGetSet = json.get("can_get_set").getAsBoolean();
        StatReq req = StatReq.nothing().fromJson(json.get("requirements").getAsJsonObject());
        String slot = json.get("gear_type").getAsString();
        return new SerializableUniqueGear(primary, unique, tier, rarity, weight, canGetSet, req, guid, name, desc, slot, loc);
    }

    @Override
    default public int Weight() {
        return this.getRarity().Weight();
    }

    public List<StatMod> uniqueStats();

    public List<StatMod> primaryStats();

    @Override
    default public int getRarityRank() {
        return 1;
    }

    @Override
    default public Rarity getRarity() {
        return Rarities.Gears.get(this.getRarityRank());
    }

    default public String getGeneratedResourceID() {
        return this.getGeneratedResourceFolderPath() + this.GUID();
    }

    default public String getGeneratedResourceFolderPath() {
        return "uniques/" + this.getGearSlot().resourceID() + "/";
    }

    default public boolean canGetSet() {
        return false;
    }

    @Override
    default public IBaseAutoLoc.AutoLocGroup locNameGroup() {
        return IBaseAutoLoc.AutoLocGroup.Unique_Items;
    }

    @Override
    default public IBaseAutoLoc.AutoLocGroup locDescGroup() {
        return IBaseAutoLoc.AutoLocGroup.Unique_Items;
    }

    @Override
    default public SlashRegistryType getSlashRegistryType() {
        return SlashRegistryType.UNIQUE_GEAR;
    }

    default public Item getItemForRegistration() {
        return (Item)BASE_UNIQUE_ITEMS.get(this.getGearSlot().GUID()).get().setRegistryName(this.getResourceLocForItem());
    }

    default public ResourceLocation getResourceLocForItem() {
        return new ResourceLocation("mmorpg", this.getGeneratedResourceID());
    }

    default public Item getUniqueItem() {
        return (Item)ForgeRegistries.ITEMS.getValue(this.getResourceLocForItem());
    }

    @Override
    default public String locDescLangFileGUID() {
        return "item." + this.getResourceLocForItem().toString() + ".desc";
    }

    @Override
    default public String locNameLangFileGUID() {
        return "item." + this.getResourceLocForItem().toString();
    }
}

