/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.unique_items;

import com.google.gson.JsonObject;
import com.robertx22.mine_and_slash.database.rarities.GearRarity;
import com.robertx22.mine_and_slash.database.stats.Stat;
import com.robertx22.mine_and_slash.onevent.data_gen.ISerializablePart;
import com.robertx22.mine_and_slash.registry.SlashRegistry;
import com.robertx22.mine_and_slash.saveclasses.gearitem.StatRequirementsData;
import com.robertx22.mine_and_slash.saveclasses.player_stat_points.LvlPointStat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class StatReq
implements ISerializablePart<StatReq> {
    private HashMap<String, Float> map = new HashMap();

    public StatReq(LvlPointStat stat, Size size) {
        this.map.put(stat.statguid, Float.valueOf(size.multi));
    }

    public StatReq(StatReq ... list) {
        for (StatReq req : list) {
            req.map.entrySet().forEach(x -> this.map.put((String)x.getKey(), (Float)x.getValue()));
        }
    }

    public StatReq(LvlPointStat stat, Size size, LvlPointStat stat2, Size size2) {
        this.map.put(stat.statguid, Float.valueOf(size.multi));
        this.map.put(stat2.statguid, Float.valueOf(size2.multi));
    }

    private StatReq() {
    }

    public static StatReq nothing() {
        return new StatReq();
    }

    @Override
    public String getJsonID() {
        return "stat_requirements";
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        this.map.entrySet().forEach(e -> json.addProperty((String)e.getKey(), (Number)e.getValue()));
        return json;
    }

    @Override
    public StatReq fromJson(JsonObject json) {
        StatReq req = new StatReq();
        Arrays.stream(LvlPointStat.values()).forEach(x -> {
            if (json.has(x.statguid)) {
                Float val = Float.valueOf(json.get(x.statguid).getAsFloat());
                req.map.put(x.statguid, val);
            }
        });
        return req;
    }

    public List<Stat> getStats() {
        return this.map.keySet().stream().map(x -> SlashRegistry.Stats().get((String)x)).collect(Collectors.toList());
    }

    public HashMap<String, Integer> getRequirements(int lvl, GearRarity rar) {
        HashMap<String, Integer> hashmap = new HashMap<String, Integer>();
        for (Map.Entry<String, Float> entry : this.map.entrySet()) {
            int val = (int)(entry.getValue().floatValue() * (float)StatRequirementsData.getAmount(lvl) * rar.requirementMulti());
            hashmap.put(entry.getKey(), val);
        }
        return hashmap;
    }

    public static enum Size {
        TINY(0.25f),
        SMALL(0.5f),
        MEDIUM(0.75f),
        NORMAL(1.0f),
        MAJOR(1.1f),
        HUGE(1.25f);

        public float multi;

        private Size(float multi) {
            this.multi = multi;
        }
    }
}

