/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.unique_items.hammers;

import com.robertx22.mine_and_slash.database.gearitemslots.bases.GearItemSlot;
import com.robertx22.mine_and_slash.database.gearitemslots.weapons.Hammer;
import com.robertx22.mine_and_slash.database.stats.StatMod;
import com.robertx22.mine_and_slash.database.stats.mods.flat.offense.CriticalDamageFlat;
import com.robertx22.mine_and_slash.database.stats.mods.generated.ElementalAttackDamageFlat;
import com.robertx22.mine_and_slash.database.stats.mods.generated.ElementalFocusFlat;
import com.robertx22.mine_and_slash.database.stats.mods.percent.offense.CriticalHitPercent;
import com.robertx22.mine_and_slash.database.unique_items.IElementalUnique;
import com.robertx22.mine_and_slash.database.unique_items.IUnique;
import com.robertx22.mine_and_slash.database.unique_items.StatReq;
import com.robertx22.mine_and_slash.saveclasses.player_stat_points.LvlPointStat;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Elements;
import java.util.Arrays;
import java.util.List;
import net.minecraft.util.text.TextFormatting;

public class HammerElemental
implements IElementalUnique {
    public Elements element;
    static StatReq req = new StatReq(LvlPointStat.STRENGTH, StatReq.Size.SMALL, LvlPointStat.INTELLIGENCE, StatReq.Size.MEDIUM);

    public HammerElemental(Elements element) {
        this.element = element;
    }

    @Override
    public StatReq getRequirements() {
        return req;
    }

    @Override
    public List<StatMod> uniqueStats() {
        return Arrays.asList(new CriticalDamageFlat().size(StatMod.Size.DOUBLE), new CriticalHitPercent().size(StatMod.Size.DOUBLE), new ElementalFocusFlat(this.element));
    }

    @Override
    public List<StatMod> primaryStats() {
        return Arrays.asList(new ElementalAttackDamageFlat(this.element).size(StatMod.Size.LOW));
    }

    @Override
    public String locDescForLangFile() {
        return "I can feel it at my fingertips.";
    }

    @Override
    public String locNameForLangFile() {
        return TextFormatting.YELLOW + "Convergence, " + this.element.dmgName + "'s Infusion";
    }

    @Override
    public String GUID() {
        return this.element.guidName + "_ele_hammer0";
    }

    @Override
    public int getRarityRank() {
        return 4;
    }

    @Override
    public int getTier() {
        return 2;
    }

    @Override
    public IUnique newInstance(Elements element) {
        return new HammerElemental(element);
    }

    @Override
    public GearItemSlot getGearSlot() {
        return Hammer.INSTANCE;
    }
}

