/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.unique_items.rings;

import com.robertx22.mine_and_slash.database.gearitemslots.bases.GearItemSlot;
import com.robertx22.mine_and_slash.database.gearitemslots.curios.Ring;
import com.robertx22.mine_and_slash.database.stats.StatMod;
import com.robertx22.mine_and_slash.database.stats.mods.flat.corestats.CoreStatFlat;
import com.robertx22.mine_and_slash.database.stats.mods.flat.resources.ManaOnHitFlat;
import com.robertx22.mine_and_slash.database.stats.mods.generated.ElementalPeneFlat;
import com.robertx22.mine_and_slash.database.stats.mods.generated.ElementalSpellDamageFlat;
import com.robertx22.mine_and_slash.database.stats.types.core_stats.Intelligence;
import com.robertx22.mine_and_slash.database.unique_items.IElementalUnique;
import com.robertx22.mine_and_slash.database.unique_items.IUnique;
import com.robertx22.mine_and_slash.database.unique_items.StatReq;
import com.robertx22.mine_and_slash.saveclasses.player_stat_points.LvlPointStat;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Elements;
import java.util.Arrays;
import java.util.List;
import net.minecraft.util.text.TextFormatting;

public class RingElemental
implements IElementalUnique {
    public Elements element;
    static StatReq req = new StatReq(LvlPointStat.INTELLIGENCE, StatReq.Size.NORMAL);

    public RingElemental(Elements element) {
        this.element = element;
    }

    @Override
    public GearItemSlot getGearSlot() {
        return Ring.INSTANCE;
    }

    @Override
    public StatReq getRequirements() {
        return req;
    }

    @Override
    public List<StatMod> uniqueStats() {
        return Arrays.asList(new ManaOnHitFlat(), new CoreStatFlat(Intelligence.INSTANCE).size(StatMod.Size.HALF_MORE), new ElementalPeneFlat(this.element).size(StatMod.Size.HALF_MORE));
    }

    @Override
    public List<StatMod> primaryStats() {
        return Arrays.asList(new ElementalSpellDamageFlat(this.element));
    }

    @Override
    public String locDescForLangFile() {
        return "I summon " + this.element.dmgName + " in my name!";
    }

    @Override
    public String locNameForLangFile() {
        return TextFormatting.YELLOW + "Ring of " + this.element.disasterName;
    }

    @Override
    public String GUID() {
        return this.element.guidName + "_ele_ring0";
    }

    @Override
    public int getRarityRank() {
        return 4;
    }

    @Override
    public int getTier() {
        return 2;
    }

    @Override
    public IUnique newInstance(Elements element) {
        return new RingElemental(element);
    }
}

