/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.unique_items.shields;

import com.robertx22.mine_and_slash.database.gearitemslots.bases.GearItemSlot;
import com.robertx22.mine_and_slash.database.gearitemslots.offhand.Shield;
import com.robertx22.mine_and_slash.database.stats.StatMod;
import com.robertx22.mine_and_slash.database.stats.mods.flat.defense.BlockStrengthFlat;
import com.robertx22.mine_and_slash.database.stats.mods.generated.BlockReflectFlat;
import com.robertx22.mine_and_slash.database.stats.mods.generated.ElementalResistFlat;
import com.robertx22.mine_and_slash.database.stats.mods.generated.ElementalSpellDamageFlat;
import com.robertx22.mine_and_slash.database.unique_items.IElementalUnique;
import com.robertx22.mine_and_slash.database.unique_items.IUnique;
import com.robertx22.mine_and_slash.database.unique_items.StatReq;
import com.robertx22.mine_and_slash.saveclasses.player_stat_points.LvlPointStat;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Elements;
import java.util.Arrays;
import java.util.List;
import net.minecraft.util.text.TextFormatting;

public class ShieldElemental
implements IElementalUnique {
    public Elements element;
    static StatReq req = new StatReq(LvlPointStat.WISDOM, StatReq.Size.NORMAL);

    public ShieldElemental(Elements element) {
        this.element = element;
    }

    @Override
    public GearItemSlot getGearSlot() {
        return Shield.INSTANCE;
    }

    @Override
    public StatReq getRequirements() {
        return req;
    }

    @Override
    public List<StatMod> uniqueStats() {
        return Arrays.asList(new ElementalSpellDamageFlat(this.element), new ElementalResistFlat(this.element));
    }

    @Override
    public String locDescForLangFile() {
        return "Fear no " + this.element.dmgName;
    }

    @Override
    public String locNameForLangFile() {
        return TextFormatting.YELLOW + "Shield of " + this.element.dmgName + " Thorns";
    }

    @Override
    public List<StatMod> primaryStats() {
        return Arrays.asList(new BlockStrengthFlat(), new BlockReflectFlat(this.element));
    }

    @Override
    public String GUID() {
        return this.element.guidName + "_ele_shield0";
    }

    @Override
    public int getRarityRank() {
        return 3;
    }

    @Override
    public int getTier() {
        return 3;
    }

    @Override
    public IUnique newInstance(Elements element) {
        return new ShieldElemental(element);
    }
}

